#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/toloka_manager/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/toloka_manager/include/task.h>

#include <string>
#include <vector>

namespace maps {
namespace mrc {
namespace toloka {

// Note: 'c12n' is a short form of 'classification'

/**
 * Input values for 'image quality classification' type of task
 *
 * @param imageUrl URL of the image to classify.
 *                 It does not need to be externally reachable.
 */

class ImageQualityC12nInput {
public:
    ImageQualityC12nInput(std::string imageUrl);

    const std::string& imageUrl() const;

    ImageQualityC12nInput& setImageUrl(std::string url);

    void json(json::ObjectBuilder) const;

private:
    std::string imageUrl_;
};

using ImageQualityC12nInputs = std::vector<ImageQualityC12nInput>;

enum class ImageQualityC12nAnswer { Ok, HasDefect, NotLoaded };

/**
 * Output values for 'image quality classification' type of task
 */
class ImageQualityC12nOutput {
public:
    ImageQualityC12nOutput(ImageQualityC12nAnswer answer);

    ImageQualityC12nAnswer answer() const;

    void json(json::ObjectBuilder) const;

    auto introspect() const {
        return answer_;
    }

private:
    ImageQualityC12nAnswer answer_;
};

/// Returns true if 'answer's in both objects are equal,
///         false otherwise
bool operator==(const ImageQualityC12nOutput& lhs, const ImageQualityC12nOutput& rhs);

/// Uses ordering by 'answer'
bool operator<(const ImageQualityC12nOutput& lhs, const ImageQualityC12nOutput& rhs);

std::ostream& operator<<(std::ostream& out, const ImageQualityC12nOutput& taskOutput);

/**
 * Task traits for image quality classification
 */
struct ImageQualityC12nTaskTraits {
    using InputType = ImageQualityC12nInput;
    using OutputType = ImageQualityC12nOutput;
    static constexpr auto DB_TASK_TYPE
        = DbTaskType::ImageQualityClassification;
};

using ImageQualityC12nTask = Task<ImageQualityC12nTaskTraits>;
using ImageQualityC12nTasks = std::vector<ImageQualityC12nTask>;

} // namespace toloka
} // namespace mrc
} // namespace maps
