#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/toloka_manager/include/common.h>
#include <maps/libs/json/include/builder.h>

#include <vector>

namespace maps {
namespace mrc {
namespace toloka {

template <typename TaskType>
class KnownSolution {
public:
    using OutputType = OutputType<TaskType>;

    KnownSolution(OutputType outputValues, double correctnessWeight);
    ~KnownSolution() {}

    const OutputType& outputValues() const;
    double correctnessWeight() const;

    void json(json::ObjectBuilder builder) const;

private:
    OutputType outputValues_;
    double correctnessWeight_;
};

template <typename T>
KnownSolution<T>::KnownSolution(OutputType outputValues,
                                double correctnessWeight)
    : outputValues_(std::move(outputValues))
    , correctnessWeight_(correctnessWeight)
{
}

template <typename T>
const OutputType<T>& KnownSolution<T>::outputValues() const
{
    return outputValues_;
}

template <typename T>
double KnownSolution<T>::correctnessWeight() const
{
    return correctnessWeight_;
}

template <typename T>
void KnownSolution<T>::json(json::ObjectBuilder builder) const
{
    builder["output_values"] = outputValues_;
    builder["correctness_weight"] = correctnessWeight_;
}

template <typename TaskType>
using KnownSolutions = std::vector<KnownSolution<TaskType>>;

} // namespace toloka
} // namespace mrc
} // namespace maps

namespace maps {
namespace json {

template <typename TaskType>
void json(const mrc::toloka::KnownSolutions<TaskType>& solutions,
          ArrayBuilder builder)
{
    builder.putRange(solutions.begin(), solutions.end());
}

} // namespace json
} // namespace maps
