#include <maps/wikimap/mapspro/services/mrc/libs/toloka_manager/tests/common.h>

namespace maps::mrc::toloka::tests {

TEST_F(Fixture, create_get_free_approvement_task_test)
{
    ApprovementInput input(DUMMY_IMAGE_URL, {});
    testCreateGetFreeTask<ApprovementTask>(pool(), input);
} // TEST_F(Fixture, create_get_free_approvement_task_test)

TEST_F(Fixture, serialize_known_solutions_approvement_task_test)
{
    KnownSolutions<ApprovementTask> solutions{KnownSolution<ApprovementTask>{
        OutputType<ApprovementTask>{ApprovementAnswer::Yes}, 0.5}
    };
    std::string expectedJson = R"(
    [
      {
        "output_values": {
          "state": "yes"
        },
        "correctness_weight": 0.5
      }
    ])";
    EXPECT_EQ(minifyJson(toJson(solutions)), minifyJson(expectedJson));
}

TEST_F(Fixture, create_known_solutions_approvement_task_test)
{
    ApprovementInput input(DUMMY_IMAGE_URL, {});
    KnownSolutions<ApprovementTask> knownSolutions{
        KnownSolution<ApprovementTask>{
            OutputType<ApprovementTask>{ApprovementAnswer::Yes}, 0.5
        }
    };
    testCreateKnownSolutionsTask<ApprovementTask>(pool(), input, knownSolutions);
} // TEST_F(Fixture, create_known_solutions_approvement_task_test)

} // namespace maps::mrc::toloka::tests
