#include <maps/wikimap/mapspro/services/mrc/libs/toloka_manager/tests/common.h>

namespace maps::mrc::toloka::tests {

TEST_F(Fixture, serialize_detection_missing_on_frame_test)
{
    const std::string IMAGE1 = "image1";
    const std::string IMAGE2 = "image2";
    const common::ImageBox BOX1(1, 2, 3, 4);

    DetectionMissingOnFrameInput input(IMAGE1, BOX1, IMAGE2);
    std::string inputStr = toJson(input);
    json::Value inputJson = json::Value::fromString(inputStr);

    EXPECT_EQ(inputJson["image1"].as<std::string>(), IMAGE1);
    const json::Value& jsonBox1 = inputJson["bbox1"];
    EXPECT_TRUE(jsonBox1.isArray());
    EXPECT_EQ(jsonBox1.size(), 2u);
    EXPECT_TRUE(jsonBox1[0].isArray());
    EXPECT_EQ(jsonBox1[0][0].as<size_t>(), 1u);
    EXPECT_EQ(jsonBox1[0][1].as<size_t>(), 2u);
    EXPECT_TRUE(jsonBox1[1].isArray());
    EXPECT_EQ(jsonBox1[1][0].as<size_t>(), 3u);
    EXPECT_EQ(jsonBox1[1][1].as<size_t>(), 4u);

    EXPECT_EQ(inputJson["image2"].as<std::string>(), IMAGE2);
} // TEST_F(Fixture, serialize_detection_missing_on_frame_test)

TEST_F(Fixture, create_get_free_detection_missing_on_frame_task_test)
{
    const std::string IMAGE1 = "image1";
    const std::string IMAGE2 = "image2";
    const common::ImageBox BOX1(1, 2, 3, 4);

    DetectionMissingOnFrameInput input(IMAGE1, BOX1, IMAGE2);
    testCreateGetFreeTask<DetectionMissingOnFrameTask>(pool(), input);
}

TEST_F(Fixture, serialize_known_solutions_detection_missing_on_frame_task_test)
{
    KnownSolutions<DetectionMissingOnFrameTask> solutions{
        KnownSolution<DetectionMissingOnFrameTask>{
            OutputType<DetectionMissingOnFrameTask>{
                DetectionMissingOnFrameIsVisible::No,
                DetectionMissingOnFrameMissingReason::Hidden
            },
            0.5
        }
    };
    std::string expectedJson = R"(
    [
      {
        "output_values": {
          "is_visible": "no",
          "missing_reason": "hidden"
        },
        "correctness_weight": 0.5
      }
    ])";
    EXPECT_EQ(minifyJson(toJson(solutions)), minifyJson(expectedJson));
} // TEST_F(Fixture, serialize_known_solutions_detection_missing_on_frame_task_test)

TEST_F(Fixture, create_known_solutions_detection_missing_on_frame_task_test)
{
    const std::string IMAGE1 = "image1";
    const std::string IMAGE2 = "image2";
    const common::ImageBox BOX1(1, 2, 3, 4);

    DetectionMissingOnFrameInput input(IMAGE1, BOX1, IMAGE2);
    KnownSolutions<DetectionMissingOnFrameTask> knownSolutions{
        KnownSolution<DetectionMissingOnFrameTask>{
            OutputType<DetectionMissingOnFrameTask>{
                DetectionMissingOnFrameIsVisible::No,
                DetectionMissingOnFrameMissingReason::Hidden
            },
            0.5
        }
    };
    testCreateKnownSolutionsTask<DetectionMissingOnFrameTask>(pool(), input, knownSolutions);
} // TEST_F(Fixture, create_known_solutions_detection_missing_on_frame_task_test)

} // namespace maps::mrc::toloka::tests
