#include <maps/wikimap/mapspro/services/mrc/libs/toloka_manager/tests/common.h>

namespace maps::mrc::toloka::tests {

TEST_F(Fixture, serialize_house_number_recognition_test)
{
    HouseNumberRecognitionInput input(DUMMY_IMAGE_URL, BOX);
    std::string inputStr = toJson(input);
    json::Value inputJson = json::Value::fromString(inputStr);

    EXPECT_EQ(inputJson["image"].as<std::string>(), DUMMY_IMAGE_URL);
    const json::Value& jsonBox = inputJson["bbox"];
    EXPECT_TRUE(jsonBox.isArray());
    EXPECT_EQ(jsonBox.size(), 2u);
    EXPECT_TRUE(jsonBox[0].isArray());
    EXPECT_EQ(jsonBox[0][0].as<size_t>(), 10u);
    EXPECT_EQ(jsonBox[0][1].as<size_t>(), 15u);
    EXPECT_TRUE(jsonBox[1].isArray());
    EXPECT_EQ(jsonBox[1][0].as<size_t>(), 20u);
    EXPECT_EQ(jsonBox[1][1].as<size_t>(), 25u);

    auto input2 = parseJson<HouseNumberRecognitionInput>(inputStr);
    EXPECT_EQ(input2.imageUrl(), DUMMY_IMAGE_URL);
    EXPECT_EQ(input2.bbox(), BOX);

    const std::string OUTPUT_VALUES = R"({"state": "ok", "house_number": "22"})";
    auto output = parseJson<HouseNumberRecognitionOutput>(OUTPUT_VALUES);
    EXPECT_TRUE(output.state() == HouseNumberRecognitionState::Ok);
    EXPECT_TRUE(output.houseNumber() == "22");

    const std::string OUTPUT_VALUES_2 = R"({"state": "not-recognized"})";
    auto output2 = parseJson<HouseNumberRecognitionOutput>(OUTPUT_VALUES_2);
    EXPECT_TRUE(output2.state() == HouseNumberRecognitionState::NotRecognized);
    EXPECT_TRUE(output2.houseNumber().empty());
} // TEST_F(Fixture, serialize_house_number_recognition_test)

TEST_F(Fixture, create_get_free_house_number_recognition_task_test)
{
    HouseNumberRecognitionInput input(DUMMY_IMAGE_URL, BOX);
    testCreateGetFreeTask<HouseNumberRecognitionTask>(pool(), input);
}

TEST_F(Fixture, serialize_known_solutions_house_number_recognition_task_test)
{
    KnownSolutions<HouseNumberRecognitionTask> solutions{
        KnownSolution<HouseNumberRecognitionTask>{
            OutputType<HouseNumberRecognitionTask>{
                HouseNumberRecognitionState::Ok,
                "33"
            },
            0.5
        }
    };
    std::string expectedJson = R"(
    [
      {
        "output_values": {
          "state": "ok",
          "house_number": "33"
        },
        "correctness_weight": 0.5
      }
    ])";
    EXPECT_EQ(minifyJson(toJson(solutions)), minifyJson(expectedJson));
} // TEST_F(Fixture, serialize_known_solutions_house_number_recognition_task_test)

TEST_F(Fixture, create_known_solutions_house_number_recognition_task_test)
{
    HouseNumberRecognitionInput input(DUMMY_IMAGE_URL, common::ImageBox(10, 15, 20, 25));
    KnownSolutions<HouseNumberRecognitionTask> knownSolutions{
        KnownSolution<HouseNumberRecognitionTask>{
            OutputType<HouseNumberRecognitionTask>{
                HouseNumberRecognitionState::Ok,
                "22"
            },
            0.5
        }
    };
    testCreateKnownSolutionsTask<HouseNumberRecognitionTask>(pool(), input, knownSolutions);
} // TEST_F(Fixture, create_known_solutions_house_number_recognition_task_test)

} // namespace maps::mrc::toloka::tests
