#include <maps/wikimap/mapspro/services/mrc/libs/toloka_manager/tests/common.h>

namespace maps::mrc::toloka::tests {

TEST_F(Fixture, create_get_free_image_quality_task_test)
{
    ImageQualityC12nInput input(DUMMY_IMAGE_URL);
    testCreateGetFreeTask<ImageQualityC12nTask>(pool(), input);
} // TEST_F(Fixture, create_get_free_image_quality_task_test)

TEST_F(Fixture, serialize_known_solutions_image_quality_task_test)
{
    KnownSolutions<ImageQualityC12nTask> solutions{
        KnownSolution<ImageQualityC12nTask>{
            OutputType<ImageQualityC12nTask>{ImageQualityC12nAnswer::Ok},
            0.5
        }
    };
    std::string expectedJson = R"(
    [
      {
        "output_values": {
          "state": "ok"
        },
        "correctness_weight": 0.5
      }
    ])";
    EXPECT_EQ(minifyJson(toJson(solutions)), minifyJson(expectedJson));
}

TEST_F(Fixture, create_known_solutions_image_quality_task_test)
{
    ImageQualityC12nInput input(DUMMY_IMAGE_URL);
    KnownSolutions<ImageQualityC12nTask> knownSolutions{
        KnownSolution<ImageQualityC12nTask>{
            OutputType<ImageQualityC12nTask>{ImageQualityC12nAnswer::Ok},
            0.5
        }
    };
    testCreateKnownSolutionsTask<ImageQualityC12nTask>(pool(), input, knownSolutions);
} // TEST_F(Fixture, create_known_solutions_image_quality_task_test)

} // namespace maps::mrc::toloka::tests
