#include <maps/wikimap/mapspro/services/mrc/libs/toloka_manager/tests/common.h>

namespace maps::mrc::toloka::tests {

TEST_F(Fixture, serialize_detection_test)
{
    DetectionInput input(DUMMY_IMAGE_URL);
    std::string inputStr = toJson(input);
    json::Value inputJson = json::Value::fromString(inputStr);

    EXPECT_EQ(inputJson["image"].as<std::string>(), DUMMY_IMAGE_URL);

    DetectionInput input2 = parseJson<DetectionInput>(inputStr);
    EXPECT_EQ(input2.imageUrl(), DUMMY_IMAGE_URL);

    const std::string OUTPUT_VALUES = R"(
        {
            "polygons": [
                {
                    "type": "rectangle",
                    "data": {"p1": {"x": 10, "y": 15}, "p2": {"x": 20, "y": 25}}
                },
                {
                    "type": "rectangle",
                    "data": {"p1": {"x": 30, "y": 35}, "p2": {"x": 40, "y": 45}}
                }
            ],
            "result": "is_not_empty"
        }
    )";
    DetectionOutput output = parseJson<DetectionOutput>(OUTPUT_VALUES);
    EXPECT_EQ(output.bboxes().size(), 2u);
    EXPECT_EQ(
        output.bboxes()[0],
        geolib3::BoundingBox(geolib3::Point2(10, 15), geolib3::Point2(20, 25))
    );
    EXPECT_EQ(
        output.bboxes()[1],
        geolib3::BoundingBox(geolib3::Point2(30, 35), geolib3::Point2(40, 45))
    );

    const std::string OUTPUT_VALUES_EMPTY = R"(
        {
            "polygons": [],
            "result": "is_empty"
        }
    )";
    DetectionOutput emptyOutput = parseJson<DetectionOutput>(OUTPUT_VALUES_EMPTY);
    EXPECT_TRUE(emptyOutput.bboxes().empty());
} // TEST_F(Fixture, serialize_detection_test)

TEST_F(Fixture, create_get_free_detection_task_test)
{
    DetectionInput input(DUMMY_IMAGE_URL);
    testCreateGetFreeTask<SignDetectionTask>(pool(), input);
} // TEST_F(Fixture, create_get_free_detection_task_test)

TEST_F(Fixture, serialize_known_solutions_detection_task_test)
{
    testSerializeKnownSolutionsDetectionTask<SignDetectionTask>();
} // TEST_F(Fixture, serialize_known_solutions_detection_task_test)

TEST_F(Fixture, create_known_solutions_sign_detection_task_test)
{
    testCreateKnownSolutionsDetectionTask<SignDetectionTask>(pool());
} // TEST_F(Fixture, create_known_solutions_sign_detection_task_test)

} // namespace maps::mrc::toloka::tests
