#include <maps/wikimap/mapspro/services/mrc/libs/toloka_manager/tests/common.h>

namespace maps::mrc::toloka::tests {

TEST_F(Fixture, create_get_free_taxonomy_task_test)
{
    TaxonomyInput input(DUMMY_IMAGE_URL, BOX);
    testCreateGetFreeTask<TaxonomyTask>(pool(), input);
} // TEST_F(Fixture, create_get_free_taxonomy_task_test)

TEST_F(Fixture, create_known_solutions_taxonomy_task_test)
{
    TaxonomyInput input(DUMMY_IMAGE_URL, common::ImageBox(10, 15, 20, 25));
    KnownSolutions<TaxonomyTask> knownSolutions{KnownSolution<TaxonomyTask>{
        OutputType<TaxonomyTask>{"1.18.1_Russian_road_marking"}, 0.5}
    };
    testCreateKnownSolutionsTask<TaxonomyTask>(pool(), input, knownSolutions);
} // TEST_F(Fixture, create_known_solutions_taxonomy_task_test)

} // namespace maps::mrc::toloka::tests
