#include <maps/wikimap/mapspro/services/mrc/libs/db/include/toloka/task.h>
#include <maps/wikimap/mapspro/services/mrc/libs/toloka_manager/include/toloka_manager.h>

#include <boost/lexical_cast.hpp>

namespace maps {
namespace mrc {
namespace toloka {

TaskIds getTaskIds(pqxx::transaction_base& txn, DbPlatform platform, DbTaskType dbTaskType)
{
    return db::toloka::TaskGateway{txn}.loadIdsByType(platform, dbTaskType);
}

TaskStatus getTaskStatus(pqxx::transaction_base& txn, TaskId taskId)
{
    auto idStatus = db::toloka::TaskGateway{txn}.loadStatusesByIds({taskId});
    REQUIRE(idStatus.size() == 1, "Cannot find task with id " << taskId);
    return idStatus.front().second;
}

std::map<TaskId, TaskStatus>
getTaskStatuses(pqxx::transaction_base& txn, const TaskIds& taskIds)
{
    auto idStatus
        = db::toloka::TaskGateway{txn}.loadStatusesByIds(std::move(taskIds));

    std::map<TaskId, TaskStatus> result;
    for (const auto& pair : idStatus) {
        result.emplace(pair.first, pair.second);
    }
    return result;
}

void freeTask(pqxx::transaction_base& txn, TaskId taskId)
{
    return freeTasks(txn, {taskId});
}

void freeTasks(pqxx::transaction_base& txn, const TaskIds& taskIds)
{
    db::toloka::TaskGateway{txn}.updateStatusByIds(TaskStatus::Free,
                                                   taskIds);
}

void cancelTask(pqxx::transaction_base& txn, TaskId taskId)
{
    return cancelTasks(txn, {taskId});
}

void cancelTasks(pqxx::transaction_base& txn, const TaskIds& taskIds)
{
    db::toloka::TaskGateway gtw{txn};
    auto tasks = gtw.loadByIds(taskIds);
    db::toloka::Tasks updatedTasks;
    updatedTasks.reserve(taskIds.size());
    for (auto& task : tasks) {
        if (task.status() == db::toloka::TaskStatus::New) {
            task.setStatus(db::toloka::TaskStatus::Cancelled);
            updatedTasks.push_back(std::move(task));
        } else if (task.status() == db::toloka::TaskStatus::InProgress) {
            task.setStatus(db::toloka::TaskStatus::Cancelling);
            updatedTasks.push_back(std::move(task));
        }
    }
    gtw.updatex(updatedTasks);
}


} // namespace toloka
} // namespace mrc
} // namespace maps
