#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/nirvana/include/nirvana_workflow.h>

namespace maps::mrc::toloka_validation {

struct TolokaCheckerInformation {
    std::string nirvanaWorkflowID;
    std::string nirvanaWorkflowInstanceID;
    std::string nirvanaBlockGUID;
};

struct TolokaEnvironment {
    std::string name;
    std::string oathTokenName;
    std::string basePoolID;
    std::string goldenTaskJsonURL;
};

enum class TolokaCheckerResultsType { Running, Success, Failed };

struct TolokaCheckerResults {
    TolokaCheckerResultsType type;
    json::Value resultsJson;
};

TolokaCheckerInformation launchTolokaChecker(
    const std::string& oauthNirvanaToken,
    const std::string& niravanaQuotaID,
    const TolokaEnvironment& tolokaEnvironment,
    const std::string& taskURL,
    const std::string& workflowID,
    bool startWorkflowInstance = true
);

TolokaCheckerResults tryGetTolokaCheckerResults(
    const std::string& oauthNirvanaToken,
    const std::string& nirvanaWorkflowID,
    const std::string& nirvanaWorkflowInstanceID,
    const std::string& nirvanaBlockGUID
);

} // namespace maps::mrc::toloka_validation
