#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/track_point.h>
#include <maps/wikimap/mapspro/services/mrc/libs/graph_matcher_adapter/include/matcher.h>

#include <vector>

namespace maps::mrc::track_classifier {

enum class TrackType {
    Undefined,
    Pedestrian,
    Vehicle
};

struct TrackInterval {
    TrackType type;
    chrono::TimePoint begin;
    chrono::TimePoint end;
};

std::vector<TrackInterval> classify(const db::TrackPoints& trackpts, const std::map<db::GraphType, const adapters::Matcher*>& graphTypeToMatcherMap);

} //maps::mrc::track_classifier
