#pragma once

#include <opencv2/opencv.hpp>

#include <memory>
#include <vector>

namespace maps {

namespace wiki {
namespace tf_inferencer {

class FasterRCNNInferencer;

} // namespace tf_inferencer
} // namespace wiki

namespace mrc::traffic_light_detector {

struct DetectedTrafficLight {
    cv::Rect box;
    float confidence;
};

using DetectedTrafficLights = std::vector<DetectedTrafficLight>;


class FasterRCNNDetector {
public:
    FasterRCNNDetector();
    ~FasterRCNNDetector();

    DetectedTrafficLights detect(const cv::Mat& image) const;

private:
    std::unique_ptr<wiki::tf_inferencer::FasterRCNNInferencer> tfInferencerFasterRCNN_;
};

} // mrc::traffic_light_detector
} // namespace maps
