#include <yandex/maps/mrc/traffic_signs/signs.h>

#include <boost/preprocessor/stringize.hpp>
#include <boost/python.hpp>

#define ENUM_VALUE(t, v) .value(BOOST_PP_STRINGIZE(v), t::v)

namespace maps {
namespace mrc {
namespace traffic_signs {


BOOST_PYTHON_MODULE(traffic_signs) {

    using namespace boost::python;

    enum_<TrafficSignCategory>("TrafficSignCategory")
        ENUM_VALUE(TrafficSignCategory, Unknown)
        ENUM_VALUE(TrafficSignCategory, YellowRhomb)
        ENUM_VALUE(TrafficSignCategory, RedCircle)
        ENUM_VALUE(TrafficSignCategory, BlueCircle)
        ENUM_VALUE(TrafficSignCategory, RedTriangleWithWhiteBackground)
        ENUM_VALUE(TrafficSignCategory, RedFlippedTriagnleWithWhiteBackgound)
        ENUM_VALUE(TrafficSignCategory, BlackCircleWithWhiteBackground)
        ENUM_VALUE(TrafficSignCategory, BlueRectangle)
        ENUM_VALUE(TrafficSignCategory, Plate)
    ;

    enum_<TrafficSign>("TrafficSign")
        ENUM_VALUE(TrafficSign, InformationAdvisorySpeedLimit)
        ENUM_VALUE(TrafficSign, InformationBicycle)
        ENUM_VALUE(TrafficSign, InformationBlindPedestrians)
        ENUM_VALUE(TrafficSign, InformationBus)
        ENUM_VALUE(TrafficSign, InformationCamping)
        ENUM_VALUE(TrafficSign, InformationCarWash)
        ENUM_VALUE(TrafficSign, InformationCheckpointInternationalRoadTransport)
        ENUM_VALUE(TrafficSign, InformationCourseOfMainRoad)
        ENUM_VALUE(TrafficSign, InformationCulDeSacF)
        ENUM_VALUE(TrafficSign, InformationCulDeSacL)
        ENUM_VALUE(TrafficSign, InformationCulDeSacR)
        ENUM_VALUE(TrafficSign, InformationDangerousRoadside)
        ENUM_VALUE(TrafficSign, InformationDirectionalL)
        ENUM_VALUE(TrafficSign, InformationDirectionalR)
        ENUM_VALUE(TrafficSign, InformationDirectionalRL)
        ENUM_VALUE(TrafficSign, InformationDirectionCursor)
        ENUM_VALUE(TrafficSign, InformationDirectionHeavyVehicleForward)
        ENUM_VALUE(TrafficSign, InformationDirectionHeavyVehicleRight)
        ENUM_VALUE(TrafficSign, InformationDirectionHeavyVehicleLeft)
        ENUM_VALUE(TrafficSign, InformationDistanceObject)
        ENUM_VALUE(TrafficSign, InformationDistanceObjectLeft)
        ENUM_VALUE(TrafficSign, InformationDistanceObjectRight)
        ENUM_VALUE(TrafficSign, InformationDistanceStopAhead)
        ENUM_VALUE(TrafficSign, InformationDrinkingWater)
        ENUM_VALUE(TrafficSign, InformationEmergencyStoppingLane)
        ENUM_VALUE(TrafficSign, InformationEmergencyTelephone)
        ENUM_VALUE(TrafficSign, InformationEofZone)
        ENUM_VALUE(TrafficSign, InformationExceptBicycle)
        ENUM_VALUE(TrafficSign, InformationExceptBus)
        ENUM_VALUE(TrafficSign, InformationExceptHeavyVehicle)
        ENUM_VALUE(TrafficSign, InformationExceptInvalids)
        ENUM_VALUE(TrafficSign, InformationExceptLightVehicle)
        ENUM_VALUE(TrafficSign, InformationExceptMotorcycle)
        ENUM_VALUE(TrafficSign, InformationExceptTaxi)
        ENUM_VALUE(TrafficSign, InformationFireExtinguisher)
        ENUM_VALUE(TrafficSign, InformationFirstAidStation)
        ENUM_VALUE(TrafficSign, InformationFood)
        ENUM_VALUE(TrafficSign, InformationFootbridge)
        ENUM_VALUE(TrafficSign, InformationGasStation)
        ENUM_VALUE(TrafficSign, InformationHeavyVehicle)
        ENUM_VALUE(TrafficSign, InformationHoliday)
        ENUM_VALUE(TrafficSign, InformationHolidayTime )
        ENUM_VALUE(TrafficSign, InformationHospital)
        ENUM_VALUE(TrafficSign, InformationHotel)
        ENUM_VALUE(TrafficSign, InformationInvalids)
        ENUM_VALUE(TrafficSign, InformationInZone)
        ENUM_VALUE(TrafficSign, InformationLane)
        ENUM_VALUE(TrafficSign, InformationLightVehicle)
        ENUM_VALUE(TrafficSign, InformationLimitMaximumWeight)
        ENUM_VALUE(TrafficSign, InformationMotorcycle)
        ENUM_VALUE(TrafficSign, InformationObstacleF)
        ENUM_VALUE(TrafficSign, InformationObstacleL)
        ENUM_VALUE(TrafficSign, InformationObstacleR)
        ENUM_VALUE(TrafficSign, InformationPaidServices)
        ENUM_VALUE(TrafficSign, InformationParking)
        ENUM_VALUE(TrafficSign, InformationParkingDeadstick)
        ENUM_VALUE(TrafficSign, InformationParkingDurationLimit)
        ENUM_VALUE(TrafficSign, InformationParkingMethod1)
        ENUM_VALUE(TrafficSign, InformationParkingMethod2)
        ENUM_VALUE(TrafficSign, InformationParkingMethod3)
        ENUM_VALUE(TrafficSign, InformationParkingMethod4)
        ENUM_VALUE(TrafficSign, InformationParkingMethod5)
        ENUM_VALUE(TrafficSign, InformationParkingMethod6)
        ENUM_VALUE(TrafficSign, InformationParkingMethod7)
        ENUM_VALUE(TrafficSign, InformationParkingMethod8)
        ENUM_VALUE(TrafficSign, InformationParkingMethod9)
        ENUM_VALUE(TrafficSign, InformationPedestrianSubway)
        ENUM_VALUE(TrafficSign, InformationPhone)
        ENUM_VALUE(TrafficSign, InformationPlaceForCarsInspection)
        ENUM_VALUE(TrafficSign, InformationPolice)
        ENUM_VALUE(TrafficSign, InformationPoolOrBeach)
        ENUM_VALUE(TrafficSign, InformationRadio)
        ENUM_VALUE(TrafficSign, InformationRadioCommunicationWithEmergencyServices)
        ENUM_VALUE(TrafficSign, InformationRestingPlace)
        ENUM_VALUE(TrafficSign, InformationServiceStation)
        ENUM_VALUE(TrafficSign, InformationSpeedCamera)
        ENUM_VALUE(TrafficSign, InformationStartZone)
        ENUM_VALUE(TrafficSign, InformationStartZoneHorizontal)
        ENUM_VALUE(TrafficSign, InformationStopLine)
        ENUM_VALUE(TrafficSign, InformationTime)
        ENUM_VALUE(TrafficSign, InformationToilet)
        ENUM_VALUE(TrafficSign, InformationTowTruck)
        ENUM_VALUE(TrafficSign, InformationTractor)
        ENUM_VALUE(TrafficSign, InformationTrafficPolice)
        ENUM_VALUE(TrafficSign, InformationTrailer)
        ENUM_VALUE(TrafficSign, InformationUTurnDistance)
        ENUM_VALUE(TrafficSign, InformationUTurnPlace)
        ENUM_VALUE(TrafficSign, InformationVehiclesCarryingDangerousGoods)
        ENUM_VALUE(TrafficSign, InformationWetCovering)
        ENUM_VALUE(TrafficSign, InformationWorkingDay)
        ENUM_VALUE(TrafficSign, InformationWorkingDayTime)
        ENUM_VALUE(TrafficSign, MandatoryCycleRoute)
        ENUM_VALUE(TrafficSign, MandatoryCyclistAndPedestriansCombinedPath)
        ENUM_VALUE(TrafficSign, MandatoryCyclistAndPedestriansSegregatedPath)
        ENUM_VALUE(TrafficSign, MandatoryDrivingDirectionL)
        ENUM_VALUE(TrafficSign, MandatoryDrivingDirectionR)
        ENUM_VALUE(TrafficSign, MandatoryDrivingDirectionRL)
        ENUM_VALUE(TrafficSign, MandatoryEofCycleRoute)
        ENUM_VALUE(TrafficSign, MandatoryEofCyclistAndPedestriansCombinedPath)
        ENUM_VALUE(TrafficSign, MandatoryEofCyclistAndPedestriansSegregatedPath)
        ENUM_VALUE(TrafficSign, MandatoryEofMinSpeed)
        ENUM_VALUE(TrafficSign, MandatoryEofPedestrianAndCyclistsSegregatedPath)
        ENUM_VALUE(TrafficSign, MandatoryMinSpeed)
        ENUM_VALUE(TrafficSign, MandatoryPedestrianAndCyclistsSegregatedPath)
        ENUM_VALUE(TrafficSign, MandatoryPedestrianPath)
        ENUM_VALUE(TrafficSign, MandatoryProceedStraight)
        ENUM_VALUE(TrafficSign, MandatoryProceedStraightOrTurnLeft)
        ENUM_VALUE(TrafficSign, MandatoryProceedStraightOrTurnRight)
        ENUM_VALUE(TrafficSign, MandatoryRoundabout)
        ENUM_VALUE(TrafficSign, MandatoryTurnLeft)
        ENUM_VALUE(TrafficSign, MandatoryTurnLeftAhead)
        ENUM_VALUE(TrafficSign, MandatoryTurnRight)
        ENUM_VALUE(TrafficSign, MandatoryTurnRightAhead)
        ENUM_VALUE(TrafficSign, MandatoryTurnRightOrLeft)
        ENUM_VALUE(TrafficSign, MandatoryVehiclesCarryingExplosivesProceedStraight)
        ENUM_VALUE(TrafficSign, MandatoryVehiclesCarryingExplosivesTurnLeftAhead)
        ENUM_VALUE(TrafficSign, MandatoryVehiclesCarryingExplosivesTurnRightAhead)
        ENUM_VALUE(TrafficSign, PrescriptionBuiltUpArea)
        ENUM_VALUE(TrafficSign, PrescriptionBusLane)
        ENUM_VALUE(TrafficSign, PrescriptionCycleLane)
        ENUM_VALUE(TrafficSign, PrescriptionEndLineLeft)
        ENUM_VALUE(TrafficSign, PrescriptionEndLineRight)
        ENUM_VALUE(TrafficSign, PrescriptionEntryToOneWayRoadOnTheLeft)
        ENUM_VALUE(TrafficSign, PrescriptionEntryToOneWayRoadOnTheRight)
        ENUM_VALUE(TrafficSign, PrescriptionEntryToRoadWithBusLaneL)
        ENUM_VALUE(TrafficSign, PrescriptionEntryToRoadWithBusLaneR)
        ENUM_VALUE(TrafficSign, PrescriptionEntryToRoadWithCycleLaneL)
        ENUM_VALUE(TrafficSign, PrescriptionEntryToRoadWithCycleLaneR)
        ENUM_VALUE(TrafficSign, PrescriptionEntryToTwoWayTraffic)
        ENUM_VALUE(TrafficSign, PrescriptionEofBuiltUpArea)
        ENUM_VALUE(TrafficSign, PrescriptionEofBusLane)
        ENUM_VALUE(TrafficSign, PrescriptionEofCycleLane)
        ENUM_VALUE(TrafficSign, PrescriptionEofLimitedAccessRoad)
        ENUM_VALUE(TrafficSign, PrescriptionEofLivingZone)
        ENUM_VALUE(TrafficSign, PrescriptionEofOneWayRoad)
        ENUM_VALUE(TrafficSign, PrescriptionEofRoadWithBusLane)
        ENUM_VALUE(TrafficSign, PrescriptionEofRoadWithCycleLane)
        ENUM_VALUE(TrafficSign, PrescriptionEofTwoWayTraffic)
        ENUM_VALUE(TrafficSign, PrescriptionLaneDirectionB)
        ENUM_VALUE(TrafficSign, PrescriptionLaneDirectionF)
        ENUM_VALUE(TrafficSign, PrescriptionLaneDirectionFFl)
        ENUM_VALUE(TrafficSign, PrescriptionLaneDirectionFFr)
        ENUM_VALUE(TrafficSign, PrescriptionLaneDirectionFl)
        ENUM_VALUE(TrafficSign, PrescriptionLaneDirectionFL)
        ENUM_VALUE(TrafficSign, PrescriptionLaneDirectionFr)
        ENUM_VALUE(TrafficSign, PrescriptionLaneDirectionFR)
        ENUM_VALUE(TrafficSign, PrescriptionLaneDirectionFrFl)
        ENUM_VALUE(TrafficSign, PrescriptionLaneDirectionFrR)
        ENUM_VALUE(TrafficSign, PrescriptionLaneDirectionL)
        ENUM_VALUE(TrafficSign, PrescriptionLaneDirectionLFl)
        ENUM_VALUE(TrafficSign, PrescriptionLaneDirectionOther)
        ENUM_VALUE(TrafficSign, PrescriptionLaneDirectionR)
        ENUM_VALUE(TrafficSign, PrescriptionLaneDirectionRL)
        ENUM_VALUE(TrafficSign, PrescriptionLanesDirection)
        ENUM_VALUE(TrafficSign, PrescriptionLimitedAccessRoad)
        ENUM_VALUE(TrafficSign, PrescriptionLivingZone)
        ENUM_VALUE(TrafficSign, PrescriptionOneWayRoad)
        ENUM_VALUE(TrafficSign, PrescriptionPedestrianCrossing)
        ENUM_VALUE(TrafficSign, PrescriptionRoadHump)
        ENUM_VALUE(TrafficSign, PrescriptionRoadWithBusLane)
        ENUM_VALUE(TrafficSign, PrescriptionRoadWithCycleLane)
        ENUM_VALUE(TrafficSign, PrescriptionStartNewLineLeft)
        ENUM_VALUE(TrafficSign, PrescriptionStartNewLineRight)
        ENUM_VALUE(TrafficSign, PrescriptionStoppingPlaceForBus)
        ENUM_VALUE(TrafficSign, PrescriptionStoppingPlaceForTaxi)
        ENUM_VALUE(TrafficSign, PrescriptionStoppingPlaceForTrams)
        ENUM_VALUE(TrafficSign, PrescriptionTwoWayLanesDirection)
        ENUM_VALUE(TrafficSign, PrescriptionTwoWayTraffic)
        ENUM_VALUE(TrafficSign, PrescriptionMotorway)
        ENUM_VALUE(TrafficSign, PrescriptionEofMotorway)
        ENUM_VALUE(TrafficSign, PriorityEofPriorityRoad)
        ENUM_VALUE(TrafficSign, PriorityGiveWay)
        ENUM_VALUE(TrafficSign, PriorityOncomingVehicles)
        ENUM_VALUE(TrafficSign, PriorityOverOncomingVehicles)
        ENUM_VALUE(TrafficSign, PriorityPriorityRoad)
        ENUM_VALUE(TrafficSign, PriorityStop)
        ENUM_VALUE(TrafficSign, PriorityStopGesture)
        ENUM_VALUE(TrafficSign, ProhibitoryCustoms)
        ENUM_VALUE(TrafficSign, ProhibitoryDanger)
        ENUM_VALUE(TrafficSign, ProhibitoryEofAll)
        ENUM_VALUE(TrafficSign, ProhibitoryEofMaxSpeed)
        ENUM_VALUE(TrafficSign, ProhibitoryEofMaxSpeed5)
        ENUM_VALUE(TrafficSign, ProhibitoryEofMaxSpeed10)
        ENUM_VALUE(TrafficSign, ProhibitoryEofMaxSpeed15)
        ENUM_VALUE(TrafficSign, ProhibitoryEofMaxSpeed20)
        ENUM_VALUE(TrafficSign, ProhibitoryEofMaxSpeed25)
        ENUM_VALUE(TrafficSign, ProhibitoryEofMaxSpeed30)
        ENUM_VALUE(TrafficSign, ProhibitoryEofMaxSpeed35)
        ENUM_VALUE(TrafficSign, ProhibitoryEofMaxSpeed40)
        ENUM_VALUE(TrafficSign, ProhibitoryEofMaxSpeed45)
        ENUM_VALUE(TrafficSign, ProhibitoryEofMaxSpeed50)
        ENUM_VALUE(TrafficSign, ProhibitoryEofMaxSpeed55)
        ENUM_VALUE(TrafficSign, ProhibitoryEofMaxSpeed60)
        ENUM_VALUE(TrafficSign, ProhibitoryEofMaxSpeed70)
        ENUM_VALUE(TrafficSign, ProhibitoryEofMaxSpeed80)
        ENUM_VALUE(TrafficSign, ProhibitoryEofMaxSpeed90)
        ENUM_VALUE(TrafficSign, ProhibitoryEofMaxSpeed100)
        ENUM_VALUE(TrafficSign, ProhibitoryEofMaxSpeed110)
        ENUM_VALUE(TrafficSign, ProhibitoryEofMaxSpeed120)
        ENUM_VALUE(TrafficSign, ProhibitoryEofMaxSpeed130)
        ENUM_VALUE(TrafficSign, ProhibitoryEofNoOvertaking)
        ENUM_VALUE(TrafficSign, ProhibitoryEofNoOvertakingByHeavyVehicle)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxHeight)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxLength)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxSpeed)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxSpeed5)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxSpeed10)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxSpeed15)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxSpeed20)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxSpeed25)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxSpeed30)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxSpeed35)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxSpeed40)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxSpeed45)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxSpeed50)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxSpeed55)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxSpeed60)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxSpeed70)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxSpeed80)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxSpeed90)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxSpeed100)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxSpeed110)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxSpeed120)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxSpeed130)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxWeight)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxWeightPerAxle)
        ENUM_VALUE(TrafficSign, ProhibitoryMaxWidth)
        ENUM_VALUE(TrafficSign, ProhibitoryMinDistance)
        ENUM_VALUE(TrafficSign, ProhibitoryNoBicycles)
        ENUM_VALUE(TrafficSign, ProhibitoryNoEntry)
        ENUM_VALUE(TrafficSign, ProhibitoryNoHeavyGoodsVehicles)
        ENUM_VALUE(TrafficSign, ProhibitoryNoHornsOrMotorNoise)
        ENUM_VALUE(TrafficSign, ProhibitoryNoHorseCarriages)
        ENUM_VALUE(TrafficSign, ProhibitoryNoLeftTurn)
        ENUM_VALUE(TrafficSign, ProhibitoryNoMotorcycles)
        ENUM_VALUE(TrafficSign, ProhibitoryNoMotorVehicles)
        ENUM_VALUE(TrafficSign, ProhibitoryNoOvertaking)
        ENUM_VALUE(TrafficSign, ProhibitoryNoOvertakingByHeavyVehicle)
        ENUM_VALUE(TrafficSign, ProhibitoryNoParking)
        ENUM_VALUE(TrafficSign, ProhibitoryNoParkingOnEvenDaysOfTheMonth)
        ENUM_VALUE(TrafficSign, ProhibitoryNoParkingOnOddDaysOfTheMonth)
        ENUM_VALUE(TrafficSign, ProhibitoryNoParkingOrStopping)
        ENUM_VALUE(TrafficSign, ProhibitoryNoPedestrians)
        ENUM_VALUE(TrafficSign, ProhibitoryNoRightTurn)
        ENUM_VALUE(TrafficSign, ProhibitoryNoTractors)
        ENUM_VALUE(TrafficSign, ProhibitoryNoTrailer)
        ENUM_VALUE(TrafficSign, ProhibitoryNoUturn)
        ENUM_VALUE(TrafficSign, ProhibitoryNoVehicles)
        ENUM_VALUE(TrafficSign, ProhibitoryNoVehiclesCarryingDangerousGoods)
        ENUM_VALUE(TrafficSign, ProhibitoryNoVehiclesCarryingExplosives)
        ENUM_VALUE(TrafficSign, ProhibitoryStop)
        ENUM_VALUE(TrafficSign, Unknown)
        ENUM_VALUE(TrafficSign, WarningChildren)
        ENUM_VALUE(TrafficSign, WarningCrossroadsMinorRoadBl)
        ENUM_VALUE(TrafficSign, WarningCrossroadsMinorRoadBr)
        ENUM_VALUE(TrafficSign, WarningCrossroadsMinorRoadFl)
        ENUM_VALUE(TrafficSign, WarningCrossroadsMinorRoadFr)
        ENUM_VALUE(TrafficSign, WarningCrossroadsMinorRoadL)
        ENUM_VALUE(TrafficSign, WarningCrossroadsMinorRoadR)
        ENUM_VALUE(TrafficSign, WarningCrossroadsMinorRoadRL)
        ENUM_VALUE(TrafficSign, WarningCrossroadsWithPriorityToTheRight)
        ENUM_VALUE(TrafficSign, WarningCyclists)
        ENUM_VALUE(TrafficSign, WarningDangerousBendL)
        ENUM_VALUE(TrafficSign, WarningDangerousBendR)
        ENUM_VALUE(TrafficSign, WarningDangerousBendsL)
        ENUM_VALUE(TrafficSign, WarningDangerousBendsR)
        ENUM_VALUE(TrafficSign, WarningDangerousCrosswinds)
        ENUM_VALUE(TrafficSign, WarningDangerousRoadside)
        ENUM_VALUE(TrafficSign, WarningDomesticAnimals)
        ENUM_VALUE(TrafficSign, WarningFallingRocksOrDebris)
        ENUM_VALUE(TrafficSign, WarningLevelCrossingCountdown1L)
        ENUM_VALUE(TrafficSign, WarningLevelCrossingCountdown1R)
        ENUM_VALUE(TrafficSign, WarningLevelCrossingCountdown2L)
        ENUM_VALUE(TrafficSign, WarningLevelCrossingCountdown2R)
        ENUM_VALUE(TrafficSign, WarningLevelCrossingCountdown3L)
        ENUM_VALUE(TrafficSign, WarningLevelCrossingCountdown3R)
        ENUM_VALUE(TrafficSign, WarningLooseChippings)
        ENUM_VALUE(TrafficSign, WarningLowFlyingAircraft)
        ENUM_VALUE(TrafficSign, WarningOpeningOrSwingBridge)
        ENUM_VALUE(TrafficSign, WarningOtherDangers)
        ENUM_VALUE(TrafficSign, WarningPedestrianCrossingAhead)
        ENUM_VALUE(TrafficSign, WarningRoadNarrowsOnBoth)
        ENUM_VALUE(TrafficSign, WarningRoadNarrowsOnLeft)
        ENUM_VALUE(TrafficSign, WarningRoadNarrowsOnRight)
        ENUM_VALUE(TrafficSign, WarningRoadworksAhead)
        ENUM_VALUE(TrafficSign, WarningRoundaboutAhead)
        ENUM_VALUE(TrafficSign, WarningSlipperyRoadSurface)
        ENUM_VALUE(TrafficSign, WarningSteepAscent)
        ENUM_VALUE(TrafficSign, WarningSteepDescent)
        ENUM_VALUE(TrafficSign, WarningTrafficJam)
        ENUM_VALUE(TrafficSign, WarningTrafficSignalsAhead)
        ENUM_VALUE(TrafficSign, WarningTramCrossingAhead)
        ENUM_VALUE(TrafficSign, WarningTunnelAhead)
        ENUM_VALUE(TrafficSign, WarningTurningDirectionL)
        ENUM_VALUE(TrafficSign, WarningTurningDirectionR)
        ENUM_VALUE(TrafficSign, WarningTurningDirectionRL)
        ENUM_VALUE(TrafficSign, WarningTwoWayTraffic)
        ENUM_VALUE(TrafficSign, WarningUnevenRoad)
        ENUM_VALUE(TrafficSign, WarningUnevenRoadAhead)
        ENUM_VALUE(TrafficSign, WarningUnprotectedQuaysideOrRiverbank)
        ENUM_VALUE(TrafficSign, WarningWildAnimals)
        ENUM_VALUE(TrafficSign, WarningLevelCrossingWithBarrierOrGateAhead)
        ENUM_VALUE(TrafficSign, WarningRailwayLevelCrossingWithoutBarrierOrGateAhead)
    ;

    def("evalCategoryOfTrafficSign", &toTrafficSignCategory);
    def("roadSignToString", (std::string (*)(TrafficSign))&toString);
    def("stringToTrafficSign", &stringToTrafficSign);
    def("roadCategorySignToString", (std::string (*)(TrafficSign))&toString);
    def("stringToTrafficSignCategory", &toTrafficSignCategory);
}


} // namespace traffic_signs
} // namespace mrc
} // namespace maps
