import unittest

from yandex.maps.mrc import traffic_signs as ts


class SignClassesUsageTests(unittest.TestCase):

    def test_constants_usage(self):
        self.assertNotEqual(ts.TrafficSignCategory.Unknown,
                            ts.TrafficSignCategory.YellowRhomb)

        self.assertNotEqual(
            ts.TrafficSign.Unknown,
            ts.TrafficSign.PriorityPriorityRoad
        )

    def test_sign_to_category_conversion(self):
        self.assertEqual(
            ts.evalCategoryOfTrafficSign(ts.TrafficSign.ProhibitoryNoEntry),
            ts.TrafficSignCategory.RedCircle)

    def test_to_string_convertion(self):
        self.assertTrue(ts.roadSignToString(ts.TrafficSign.Unknown))

        WRONG_ENUM_VALUE = 100500
        with self.assertRaises(Exception):
            ts.roadSignToString(WRONG_ENUM_VALUE)

        rs = ts.TrafficSign.ProhibitoryMaxSpeed5
        self.assertEqual(
            ts.stringToTrafficSign(
                ts.roadSignToString(rs)
            ),
            rs
        )

        self.assertEqual(
            ts.roadSignToString(
                ts.TrafficSign.ProhibitoryMaxSpeed70),
            "prohibitory_max_speed_70"
        )


if __name__ == "__main__":
    unittest.main()
