#pragma once
#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/tskv_logger/include/rotating_file_logger.h>

#include <functional>
#include <optional>
#include <string>

namespace maps::mrc::ugc_event_logger {
using GetCurrentTimestampFunc = std::function<chrono::TimePoint()>;

struct UserInfo {
    std::string ip;
    std::optional<uint16_t> port;
    std::optional<std::string> uid;
};

enum class Action {
    Create,
    Update,
    Delete,
    View,
};

struct Photo {
    std::string id;
    std::optional<bool> showAuthorship = {};
};

class Logger {
public:
    Logger(const std::string& path, std::chrono::seconds rotationPeriod, std::optional<GetCurrentTimestampFunc> getCurrentTimestamp = {});

    void logEvent(const UserInfo& user, Action action, const Photo& photo);

private:
    tskv_logger::RotatingFileLogger rotatingFileLogger_;
    GetCurrentTimestampFunc getCurrentTimestamp_;
};

} // namespace maps::mrc::ugc_event_logger
