#include <maps/wikimap/mapspro/services/mrc/libs/ugc_event_logger/include/logger.h>

#include <maps/libs/common/include/file_utils.h>

#include <library/cpp/testing/gtest/gtest.h>
#include <library/cpp/testing/unittest/env.h>

#include <memory>

namespace maps::mrc::ugc_event_logger::tsets {
    TEST(logger_should, basic_test) {
        ui64 counter = 0;
        GetCurrentTimestampFunc getCurrentTimestamp = [&]() {
            return chrono::TimePoint(chrono::TimePoint::duration(counter++));
        };

        const std::string logfile = "event.log";
        auto loggerHandler = std::make_unique<Logger>(logfile, std::chrono::seconds(600), getCurrentTimestamp);

        const UserInfo user1{.ip = "127.0.0.1"};
        const UserInfo user2{.ip = "127.0.0.1", .port = 1000};
        const UserInfo user3{.ip = "127.0.0.1", .port = 1000, .uid = "1234566"};

        loggerHandler->logEvent(user1, Action::Create, Photo{"1"});
        loggerHandler->logEvent(user2, Action::Update, Photo{"1", true});
        loggerHandler->logEvent(user3, Action::Delete, Photo{"1"});
        loggerHandler->logEvent(user3, Action::View, Photo{"1"});


        loggerHandler.reset();
        const std::string EXPECTED_LOG =
R"({"timestamp":"0","user":{"ip":"127.0.0.1"},"object":{"type":"photo","id":"1"},"action":"create"}
{"timestamp":"0","user":{"ip":"127.0.0.1","port":1000},"object":{"type":"photo","id":"1","show_authorship":true},"action":"update"}
{"timestamp":"0","user":{"ip":"127.0.0.1","port":1000,"uid":"1234566"},"object":{"type":"photo","id":"1"},"action":"delete"}
{"timestamp":"0","user":{"ip":"127.0.0.1","port":1000,"uid":"1234566"},"object":{"type":"photo","id":"1"},"action":"view"}
)";

        std::string logContents = common::readFileToString(logfile);
        EXPECT_EQ(logContents, EXPECTED_LOG);
    }

}
