#pragma once

#include <yandex/maps/mrc/unittest/unittest_config.h>

#include <maps/libs/config/include/config.h>
#include <maps/libs/local_postgres/include/instance.h>
#include <maps/libs/pgpool/include/pgpool3.h>
#include <maps/libs/xml/include/xml.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>

#include <cstdint>
#include <string>
#include <vector>

namespace maps {
namespace mrc {
namespace unittest {

/**
 * Unittest utility class to be used as fixture:
 * 1. Starts local postgres instance
 * 2. Overwrite the config file
 * 3. Creates pgpool
 * 4. Applies corresponding migrations
 */
class DatabaseFixture {
public:
    explicit DatabaseFixture(xml3::Doc& configDoc);
    virtual ~DatabaseFixture() = default;

    pgpool3::Pool& pool();

    common::SharedPool sharedPool();

    std::string connStr() const;

    local_postgres::Database& postgres() { return postgres_; }

private:
    static local_postgres::Database& blankDb();

    local_postgres::Database postgres_;
    common::SharedPool sharedPool_;
};

} // unittest
} // mrc
} // maps
