#pragma once

#include <contrib/libs/opencv/include/opencv2/opencv.hpp>

namespace maps::mrc::unittest {

// Check the max difference between pixels (actually between intensity of
// channels of each pixel) of two images less or equals two (this we consider
// acceptable difference).
inline bool areImagesEq(const cv::Mat& lhs, const cv::Mat& rhs)
{
    if (lhs.type() != rhs.type() || lhs.size != rhs.size) {
        return false;
    }
    return cv::norm(lhs, rhs, cv::NORM_INF) <= 2;
}

} // namespace maps::mrc::unittest
