#!/usr/bin/env python

from flask import Flask, request, make_response
import hashlib
import sys

BLACK_JPG_224x244x3_MD5_HASH = "1ccdf50132d3cbc1de498f499140dc98"


def get_md5_hash(data):
    md5_hasher = hashlib.md5()
    md5_hasher.update(data)
    return md5_hasher.hexdigest().lower()


app = Flask(__name__)
sys.stdout = sys.stderr
BadRepresentation = '''Bad binary representation of image'''
BadResponse = '''
        {
       "AppTimestamp" : "Jun  5 2018 16:01:01",
       "NNetClassifiersTopClasses" : {
          "prod_v6_sm_imagenet_10K" : [
             [ 7464, 62 ],
             [ 7504, 25 ],
             [ 8027, 12 ],
             [ 7983, 12 ],
             [ 8034, 11 ],
             [ 8003, 11 ],
             [ 8231, 10 ],
             [ 2402, 5 ],
             [ 7708, 5 ],
             [ 7948, 4 ]
          ]
       },
       "NeuralNetClasses" : {
          "500px_0" : 135,
          "bad_quality" : 81,
          "bad_quality_v2" : 211,
          "beautiful" : 8,
          "binary_porn" : 253,
          "child_porn" : 0,
          "collage" : 0,
          "geo" : 0,
          "gruesome" : 0,
          "market" : 0,
          "mobile" : 0,
          "ocr_text" : 3,
          "pairwise_attr_0" : 126,
          "perversion" : 4,
          "porn_with_erotic_0" : 253,
          "right_clickable" : 7,
          "tv" : 0,
          "wallpaper" : 0,
          "watermarks" : 237
       }
    }
    '''
GoodResponse = '''
    {
       "AppTimestamp" : "Jun  5 2018 16:01:01",
       "NNetClassifiersTopClasses" : {
          "prod_v6_sm_imagenet_10K" : [
             [ 5469, 54 ],
             [ 5752, 33 ],
             [ 2142, 17 ],
             [ 3962, 15 ],
             [ 5470, 13 ],
             [ 5468, 13 ],
             [ 5788, 8 ],
             [ 5754, 7 ],
             [ 2584, 5 ],
             [ 3337, 4 ]
          ]
       },
       "NeuralNetClasses" : {
          "500px_0" : 121,
          "bad_quality" : 92,
          "bad_quality_v2" : 231,
          "beautiful" : 0,
          "binary_porn" : 0,
          "child_porn" : 0,
          "collage" : 0,
          "geo" : 219,
          "gruesome" : 0,
          "market" : 0,
          "mobile" : 0,
          "ocr_text" : 0,
          "pairwise_attr_0" : 84,
          "perversion" : 0,
          "porn_with_erotic_0" : 0,
          "right_clickable" : 0,
          "tv" : 1,
          "wallpaper" : 0,
          "watermarks" : 0
       }
    }'''


@app.route('/imageparser-v6__v012/http_parse', methods=['POST'])
def yavision():
    if not request.data:
        return make_response(BadRepresentation, 400)

    if request.data.startswith("bad"):
        return make_response(BadResponse, 200)
    if get_md5_hash(request.data) == BLACK_JPG_224x244x3_MD5_HASH:
        return make_response(BadResponse, 200)

    return make_response(GoodResponse, 200)


def main(argv=sys.argv):
    # Make flask to use HTTP/1.1 protocol (to support Keep Alive connections)
    from BaseHTTPServer import BaseHTTPRequestHandler
    BaseHTTPRequestHandler.protocol_version = "HTTP/1.1"

    app.run(sys.argv[1], sys.argv[2])


if __name__ == "__main__":
    main()
