#include <library/cpp/testing/gtest/gtest.h>
#include <yandex/maps/mrc/unittest/database_fixture.h>

namespace maps {
namespace mrc {
namespace unittest {
namespace tests {

struct Db : testing::Test, WithUnittestConfig<DatabaseFixture> {
};

TEST_F(Db, test_data_1)
{
    auto txn = pool().masterWriteableTransaction();
    txn->exec(R"(
INSERT INTO signals.feature (source_id, pos, heading, mds_path, mds_group_id, date,
                             dataset, is_published)
VALUES (
    'test1',
    '0101000020430D0000DF5EA09126AF52419178BDBB5AF15C41',
    105.412000000000006,
    '1460732825/MRC_20160401_085709_1010624788.jpg',
    '4510',
    '2016-04-01 05:57:09+03',
    'agents',
    true
)
)");
    auto res = txn->exec("SELECT COUNT(*) FROM signals.feature;");
    EXPECT_EQ(res.front().front().as<size_t>(), 1u);
    txn->commit();
}

TEST_F(Db, test_data_2)
{
    auto txn = pool().masterReadOnlyTransaction();
    auto res = txn->exec("SELECT COUNT(*) FROM signals.feature;");
    EXPECT_EQ(res.front().front().as<size_t>(), 0u);
}

} //namespace tests
} //namespace unittest
} //namespace mrc
} //namespace maps
