#include <library/cpp/testing/common/env.h>
#include <library/cpp/testing/gtest/gtest.h>
#include <maps/libs/http/include/http.h>
#include <yandex/maps/mrc/unittest/local_server.h>

#include <sstream>

namespace maps {
namespace mrc {
namespace unittest {
namespace tests {

namespace {

const char* SERVER_BINARY_PATH
        = "maps/wikimap/mapspro/services/mrc/libs/unittest/tests/pyserver/pyserver";
const char* LOCAL_HOST = "127.0.0.1";

std::string pingUrl(uint16_t port)
{
    std::ostringstream url;
    url << "http://" << LOCAL_HOST << ":" << port << "/ping";
    return url.str();
}

}

TEST(local_server, start_server)
{
    const TestServer testServer(
        [](uint16_t port) {
            return process::Command(
                   {BinaryPath(SERVER_BINARY_PATH),
                   LOCAL_HOST,
                   std::to_string(port)});
        });

    http::Client httpClient;
    http::Request request(httpClient, http::GET, pingUrl(testServer.getPort()));
    auto response = request.perform();
    EXPECT_EQ(response.status(), 200);
}

} //namespace tests
} //namespace unittest
} //namespace mrc
} //namespace maps

