#include "type_wrappers.h"

#include <maps/libs/common/include/exception.h>

#include <opencv2/opencv.hpp>

#include <chrono>
#include <deque>
#include <string>

namespace maps::mrc::video {

using TimeInterval = std::chrono::milliseconds;

struct Frame {
    cv::Mat frame;
    TimeInterval timeFromStart;
};

class VideoFramesReader {
public:
    VideoFramesReader();

    /// Open video from a file or url
    void open(const std::string& uri);

    /// Closes the opened video
    void close();

    /// Read next frame from the opened video
    std::optional<Frame> readFrame();

    /// Seeks to specified position in the opened video
    /// Note: this function seeks to the nearest keyframe
    void seek(TimeInterval timeFromStart);

    /// Duration of the opened video
    TimeInterval duration() const;

private:
    AVFormatContextWrapper avFormatContext_;
    AVStreamWrapper avVideoStream_;
    SwsContextWrapper swsContext_;
    AVFrameWrapper avFrame_;

    std::deque<Frame> frames_;

    TimeInterval duration_{0};
    double fps_{0.};
    int frameIndex_{-1};
    int videoStreamIndex_{-1};
    bool isEOF_{true};

    void initVideoStream();

    void initSwsContext();

    void grabFrames();

    AVPacketWrapper readPacket();

    cv::Mat avFrameToCvMat(AVFrame* avFrame);
};

} // namespace maps::mrc::video
