#include <maps/wikimap/mapspro/services/mrc/libs/yt/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/libs/yt/include/serialization.h>

#include <util/generic/string.h>

namespace maps::mrc::yt {
namespace {

const TString MRC_CONFIG = "mrc_config";

} // namespace

NYT::TNode createSecureVault(const common::Config& config)
{
    return NYT::TNode::CreateMap()
        (MRC_CONFIG, serialize(config.toString()));
}

Configured::Configured(): config_(createConfig()) {}

Configured::ConfigPtr Configured::createConfig()
{
    const auto secureVault = NYT::GetJobSecureVault();

    if (secureVault.IsUndefined()) {
        return nullptr;
    }

    const auto mrcConfig = secureVault[MRC_CONFIG];
    REQUIRE(!mrcConfig.IsUndefined(), "Impossible load mrc config");

    return std::make_unique<common::Config>(
        common::Config::fromString(yt::deserialize<std::string>(mrcConfig))
    );
}

const common::Config& Configured::config() const
{
    REQUIRE(config_, "Mrc config is undefined");
    return *config_;
}

} // namespace maps::mrc::yt
