#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/yt/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>

#include <mapreduce/yt/interface/client.h>

#include <optional>

namespace maps::mrc::yt {

size_t getRowCount(NYT::ICypressClient& client, TString tablePath);

Mapper* makeUploadFeatureImageMapper(size_t timeoutSeconds, size_t tryN=3);

// Upload feature's image from MDS and extend feature with field 'image'.
// If the image is failed to load, null value is stored.
//
// Remark: fromTable and toTable may be the same
// Warning: Mds has limitations on downloading images from one basket.
void uploadFeatureImage(
        const common::Config& config,
        NYT::IClientBase& client,
        const TString& fromTable,
        const TString& toTable,
        std::optional<size_t> hintOnJobN = std::nullopt,
        const NYT::TNode& operationOptions
            = NYT::TNode::CreateMap()("title", "Upload image for feature")
        );

} // namespace maps::mrc::yt
