#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/table_traits.h>

#include <maps/libs/introspection/include/introspect.h>

#include <type_traits>

namespace maps::mrc::yt {

template<class T>
struct IsTableSerializabel:
    std::bool_constant<introspection::is_introspectable_v<T> and db::hasTable<T>>
{};

template<class T>
constexpr bool isTableSerializabel = IsTableSerializabel<T>::value;

template<class T, class E = void>
struct HasColumns: std::false_type {};

template<class T>
struct HasColumns<T, std::void_t<decltype(T::columns())>>: std::true_type {};

template<class T>
constexpr bool hasColumns = HasColumns<T>::value;

template<class T>
struct IsSerializable:
    std::bool_constant<introspection::is_introspectable_v<T> and hasColumns<T>>
{};

template<class T>
constexpr bool isSerializabel = IsSerializable<T>::value;

} // namespace maps::mrc::yt