#include <maps/wikimap/mapspro/services/mrc/libs/yt/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/yt/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/libs/yt/include/io.h>

#include <mapreduce/yt/tests/yt_unittest_lib/yt_unittest_lib.h>

#include <library/cpp/testing/unittest/registar.h>

#include <vector>

namespace maps::mrc::yt::tests {

class FakeMap: public Mapper, public Configured {

public:
    void Do(Reader*, Writer*) override { config(); }
};

REGISTER_MAPPER(FakeMap);

struct FakeObject {
    int number;

    template<class T>
    static auto introspect(T& t) { return std::tie(t.number); }

    static constexpr auto columns() { return std::make_tuple("number"); }

};

Y_UNIT_TEST_SUITE(config) {

Y_UNIT_TEST(save_load_config)
{
    const TString path = "//tmp/maps-wiki-mrc-yt-test";

    std::vector<FakeObject> fakes {
        FakeObject{1},
        FakeObject{2},
        FakeObject{3},
    };

    auto client = NYT::NTesting::CreateTestClient();
    saveToTable(*client, path, fakes);

    client->Map(
        NYT::TMapOperationSpec()
            .AddInput<NYT::TNode>(path)
            .AddOutput<NYT::TNode>(path),
        new FakeMap(),
        NYT::TOperationOptions()
            .SecureVault(createSecureVault(common::Config::forTests()))
    );
}

} // Y_UNIT_TEST_SUITE

} // namespace maps::mrc::yt::tests
