#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/yt/include/io.h>

#include <mapreduce/yt/tests/yt_unittest_lib/yt_unittest_lib.h>

#include <library/cpp/testing/unittest/registar.h>

namespace maps::mrc::yt::tests {

const auto one =
    db::Feature{
        "source",
        geolib3::Point2{10.0, 20.0},
        geolib3::Heading{100.0},
        "2016-04-01 00:00:00+03",
        mds::Key{"4510", "1460732825/MRC_20160401_085709_1010624788.jpg"},
        db::Dataset::Agents}
        .setSize({1920, 1024})
        .setAutomaticShouldBePublished(true)
        .setIsPublished(true);

const auto two =
    db::Feature{
        "source",
        geolib3::Point2{11.0, 23.0},
        geolib3::Heading{40.0},
        "2016-04-01 00:00:01+03",
        mds::Key{"4510", "1460732825/MRC_20160401_085709_1014424788.jpg"},
        db::Dataset::Agents}
        .setSize({1920, 1024})
        .setAutomaticShouldBePublished(true)
        .setIsPublished(true);

const auto three =
    db::Feature{
        "source",
        geolib3::Point2{15.0, 23.0},
        geolib3::Heading{189.0},
        "2016-04-01 00:00:02+03",
        mds::Key{"4510", "1462732825/MRC_20160401_085709_1014424788.jpg"},
        db::Dataset::Agents}
        .setSize({1920, 1024})
        .setAutomaticShouldBePublished(true)
        .setIsPublished(true);

Y_UNIT_TEST_SUITE(io) {

Y_UNIT_TEST(save_and_load_table)
{
    auto client = NYT::NTesting::CreateTestClient();

    const db::Features features{one, two, three};
    const TString path = "//tmp/maps-wiki-mrc-yt-test";

    saveToTable(*client, path, features);
    const auto loaded = loadFromTable<db::Features>(*client, path);

    UNIT_ASSERT_EQUAL(loaded.size(), features.size());
}

} // Y_UNIT_TEST_SUITE

} // namespace maps::mrc::yt::tests
