#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/yt/include/serialization_access.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/table_traits.h>

#include <maps/libs/sql_chemistry/include/gateway.h>
#include <maps/libs/enum_io/include/enum_io_fwd.h>

#include <string>
#include <string_view>
#include <tuple>

namespace maps::mrc {
namespace db {

struct Object {
    int64_t number;
    std::string text;

private:
    friend class sql_chemistry::GatewayAccess<Object>;

    template<class T>
    static auto introspect(T& t) { return std::tie(t.number, t.text); }

public:
    auto introspect() const { return introspect(*this); }
};

namespace table {

using namespace sql_chemistry;

struct Object: Table<db::Object> {
    static constexpr std::string_view name_{"object"};

    static constexpr NumericColumn<int64_t> number{"number"sv, name_};
    static constexpr StringColumn text{"text"sv, name_};

    static constexpr auto columns_() { return std::tie(number, text); }
};

} // namespace table

template<>
struct TableTraits<Object> {
    using Table = table::Object;
};

} // namepsace db

struct Object {
    int64_t number;
    std::string text;

private:
    friend class yt::SerializationAccess<Object>;

    template<class T>
    static auto introspect(T& t) { return std::tie(t.number, t.text); }

public:
    auto introspect() const { return introspect(*this); }

    static constexpr auto columns() { return std::make_tuple("number", "text"); }
};

enum class SomeEnum { One = 1, Two = 2 };

DECLARE_ENUM_IO(SomeEnum);

} // namespace maps::mrc

