#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/types.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ugc/assignment_object.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ugc/ugc.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/visibility.h>
#include <maps/libs/common/include/make_batches.h>
#include <maps/libs/common/include/math.h>
#include <maps/libs/geolib/include/direction.h>
#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/polyline.h>
#include <maps/libs/geolib/include/segment.h>
#include <yandex/maps/wiki/common/date_time.h>

#include <cstdint>
#include <string>
#include <vector>
#include <unordered_map>

namespace maps {
namespace mrc {
namespace img_qa {

const std::string DEFAULT_LOCALE = "ru_RU";

constexpr double GOOD_QUALITY_THRESHOLD = .5;
constexpr double BAD_QUALITY_THRESHOLD = .05;

using FeatureBatch = maps::common::Batch<db::Features>;
using PhotoIdToTolokaStatusMap
    = std::unordered_map<db::TId, db::ugc::TolokaStatus>;
using Strings = std::vector<std::string>;

struct TolokaStatistics {
    db::TId assignmentId = 0;
    size_t total = 0;
    size_t tolokaAccept = 0;
    size_t tolokaReject = 0;
    size_t tolokaInProgress = 0;
    size_t tolokaComing = 0;
};

using Segments = db::Segments;

struct SegmentsCoverage {
    Segments coveredParts;
    Segments uncoveredParts;
    double coverageFraction{0.};
};

struct CoverageStatistics {
    db::TId assignmentId{0};
    db::CameraDeviation cameraDeviation{db::CameraDeviation::Front};
    SegmentsCoverage allPhotosCoverage;
    SegmentsCoverage goodPhotosCoverage;
    double trackDistanceInMeters{0.};
    std::chrono::seconds trackDuration{0};
    size_t processedPhotos{0};
    size_t goodPhotos{0};
    size_t processedPoints{0};
    db::OptionalTimePoint firstShotTime;
    db::OptionalTimePoint lastShotTime;
    geolib3::PolylinesVector track;
};

struct TrackSegment {
    geolib3::Segment2 segment;
    chrono::TimePoint startTime;
    chrono::TimePoint endTime;
};

using TrackSegments = std::vector<TrackSegment>;

struct LineStyle {
    std::string description;
    std::string color; // RGB, e.g. #ff0000
    double width = 1;
    double opacity = 1; // 0.0(transparent) - 1.0(opaque)
};

} // img_qa
} // mrc
} // maps
