#pragma once

#include "common.h"

#include <maps/wikimap/mapspro/services/mrc/libs/blackbox_client/include/blackbox_client.h>
#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/assignment_object_feedback_task_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/track_point.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ugc/assignment_object.h>
#include <maps/wikimap/mapspro/services/mrc/libs/toloka_manager/include/toloka_manager.h>
#include <yandex/maps/mds/mds.h>

namespace maps {
namespace mrc {
namespace img_qa {

/// @brief wrapper for all configurable resources
class Context {
public:
    explicit Context(const common::Config& cfg,
                     const auth::TvmtoolSettings& = auth::TvmtoolSettings());

    pgpool3::TransactionHandle masterReadOnlyTransaction();
    pgpool3::Pool& pool();

    db::TIds loadActiveAndCompletedAssignmentIds();

    bool existsUnprocessedPhotos(db::TId assignmentId);

    db::Features loadProcessedPhotos(db::TId assignmentId);

    db::Features loadProcessedPhotos(db::TId assignmentId,
                                     db::CameraDeviation);

    db::FeatureQaTasks loadFeatureQaTasks(const FeatureBatch&);

    db::TrackPoints loadAssignmentTrackPoints(db::TId assignmentId);

    db::ugc::Assignment loadAssignment(db::TId assignmentId);

    db::ugc::Task loadTask(db::TId taskId,
                           db::ugc::LoadNames loadNames,
                           db::ugc::LoadTargets loadTargets);

    std::optional<db::ugc::AssignmentReview>
    loadAssignmentReview(db::TId assignmentId, db::CameraDeviation);

    toloka::ImageQualityC12nTasks
        createImageQualityC12nTasks(FeatureBatch);

    toloka::ImageQualityC12nTasks
    getImageQualityC12nTasks(const db::FeatureQaTasks&);

    db::AssignmentObjectFeedbackTasks createAssignmentObjectFeedbackTasks(
        const db::ugc::Assignment& assignment);

    void insert(db::FeatureQaTasks&);

    void update(db::Features&);

    void save(db::ugc::AssignmentReview&);

    void update(db::ugc::Assignment&, db::AssignmentObjectFeedbackTasks&& = {});

    std::string makeReadUrl(const db::Feature&);

    std::string makeBrowserUrl(const db::Feature&);

    std::string loadUserLogin(db::TId assignmentId);

    db::ugc::AssignmentObjects loadAssignmentObjects(db::TId assignmentId);

    /// The task has been updated since the last processing
    bool isAssignmentUpdated(db::TId assignmentId);

    Strings loadEmails(db::TId tasksGroupId);

private:
    wiki::common::PoolHolder poolHolder_;
    mds::Mds mds_;
    mds::Mds publicMds_;
    http::URL mrcBrowserUrl_;
    blackbox_client::BlackboxClient blackboxClient_;

    bool isVisible(const db::ugc::AssignmentObject&);

    std::vector<mds::Key> postToPublicMdsWithCorrectOrientation(FeatureBatch);

    void deleteMdsFiles(const std::vector<mds::Key>&);

    common::Blob loadFeatureImage(const db::Feature&);
};

} // img_qa
} // mrc
} // maps
