#pragma once

#include "common.h"

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/track_point.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ugc/assignment_object.h>

namespace maps {
namespace mrc {
namespace img_qa {

class GeojsonBuilder {
public:
    void addTrack(geolib3::PolylinesVector lines, LineStyle params); // sink

    void addAssignmentObjects(const db::ugc::AssignmentObjects&);

    void writeToFile(const std::string& filename);

    std::string generateGeojsonString();

private:
    struct Track {
        geolib3::PolylinesVector lines;
        LineStyle params;
    };

    std::vector<Track> tracks;
    db::ugc::AssignmentObjects assignmentObjects;
};

} // img_qa
} // mrc
} // maps
