#include "share_images.h"
#include "inspect_quality.h"
#include "tools.h"

#include <maps/libs/common/include/exception.h>
#include <maps/libs/log8/include/log8.h>

namespace maps {
namespace mrc {
namespace img_qa {

void shareImages(Context& ctx, db::TId assignmentId, bool modifyData)
{
    auto allPhotos = ctx.loadProcessedPhotos(assignmentId);
    slice(allPhotos, [&](db::Features::iterator begin,
                         db::Features::iterator end) {
        auto photoToStatusMap = loadPhotoToTolokaStatusMap(ctx, {begin, end});
        db::Features photos;
        for (auto it = begin; it != end; ++it) {
            auto& feature = *it;

            if (isPhotoGood(feature, photoToStatusMap) && feature.hasPos() &&
                feature.hasHeading() && feature.hasSize() &&
                !feature.automaticShouldBePublished().value_or(false)) {
                feature.setAutomaticShouldBePublished(true);
                photos.push_back(feature);
            }
        }
        if (modifyData) {
            ctx.update(photos);
        }
    });
}

} // img_qa
} // mrc
} // maps
