INSERT INTO ugc.task (task_id, status, hull, duration, distance, camera_deviations)
VALUES
(1, 'acquired', ST_GeomFromText('MULTIPOLYGON(((43.9805941 56.214804592,43.941756557 56.253266991,43.977558457 56.27524928,43.977737624 56.275231126,44.063668576 56.232743111,43.9805941 56.214804592)))', 4326), 5415, 54545.8, null),
(2, 'new', ST_GeomFromText('MULTIPOLYGON(((43.9805941 56.214804592,43.941756557 56.253266991,43.977558457 56.27524928,43.977737624 56.275231126,44.063668576 56.232743111,43.9805941 56.214804592)))', 4326), 5415, 54545.8, null),
(3, 'acquired', ST_GeomFromText('MULTIPOLYGON(((43.9805941 56.214804592,43.941756557 56.253266991,43.977558457 56.27524928,43.977737624 56.275231126,44.063668576 56.232743111,43.9805941 56.214804592)))', 4326), 5415, 54545.8, ARRAY[0,90]);

SELECT setval('ugc.task_task_id_seq', 4);

INSERT INTO ugc.task_name (task_id, locale, value)
VALUES
(1, 'ru', 'noname1'),
(2, 'ru', 'noname2'),
(3, 'ru', 'noname3');

INSERT INTO ugc.target (task_id, oneway, traffic, direction, geom)
VALUES
(1, false, 'right-hand', 'bidirectional', ST_GeomFromText('LINESTRING(43.981049 56.215127, 43.980559 56.214800, 43.980279 56.214542)', 4326)),
(2, false, 'right-hand', 'bidirectional', ST_GeomFromText('LINESTRING(43.981049 56.215127, 43.980559 56.214800, 43.980279 56.214542)', 4326)),
(3, false, 'right-hand', 'bidirectional', ST_GeomFromText('LINESTRING(43.981049 56.215127, 43.980559 56.214800, 43.980279 56.214542)', 4326));

INSERT INTO ugc.assignment (assignment_id, task_id, status, assigned_to, acquired_at, expires_at, submitted_at)
VALUES
(1, 1, 'completed', 1234, '2017-05-16 19:11:47+03', '2017-05-26 19:11:47+03', '2017-05-17 21:31:03+03'),
(3, 3, 'completed', 1234, '2017-05-16 19:11:47+03', '2017-05-26 19:11:47+03', '2017-05-17 21:31:03+03');

SELECT setval('ugc.assignment_assignment_id_seq', 4);

INSERT INTO signals.feature (assignment_id, source_id, dataset, pos, heading, date, width, height, mds_group_id, mds_path, quality, road_probability, forbidden_probability, processed_at, automatic_should_be_published, should_be_published, is_published, camera_deviation)
VALUES
(1, '123', 'agents', ST_Transform(ST_GeomFromText('POINT(43.980807 56.214992)', 4326), 3395), 30, '2017-05-17 11:03:18+03', 6, 9, '100500', 'unittest/1', 0.7, 0.9, 0, '2017-06-04 11:42:37+03', true, true, false, 0),
(1, '123', 'agents', ST_Transform(ST_GeomFromText('POINT(43.980652 56.214880)', 4326), 3395), 30, '2017-05-17 11:03:19+03', 6, 9, '100500', 'unittest/2', 0.6, 0.9, 0, '2017-06-04 11:42:37+03', true, true, false, 0),
(1, '123', 'agents',ST_Transform(ST_GeomFromText('POINT(43.980559 56.214800)', 4326), 3395), 30,  '2017-05-17 11:03:20+03', 6, 9, '100500', 'unittest/3', 0.5, 0.9, 0, '2017-06-04 11:42:37+03', true, true, false, 0),
(1, '123', 'agents', ST_Transform(ST_GeomFromText('POINT(43.980467 56.214719)', 4326), 3395), 30, '2017-05-17 11:03:21+03', 6, 9, '100500', 'unittest/4', 0.4, 0.9, 0, '2017-06-04 11:42:37+03', false, false, false, 0),
(1, '123', 'agents', ST_Transform(ST_GeomFromText('POINT(43.980381 56.214626)', 4326), 3395), 30, '2017-05-17 11:03:22+03', 6, 9, '100500', 'unittest/5', 0.03, 0.9, 0, '2017-06-04 11:42:37+03', false, false, false, 0),
(1, '123', 'agents', null, null, '2017-05-17 11:03:23+03', 6, 9, '100500', 'unittest/6', 0.7, null, null, null, false, false, false, null),
(1, '123', 'agents', ST_Transform(ST_GeomFromText('POINT(34.609718 31.677528)', 4326), 3395), 5, '2017-05-18 08:14:47+03', 6, 9, '100500', 'unittest/7', 0.3, 0.9, 0, '2017-06-04 11:42:37+03', false, false, false, 0),
(3, '200', 'agents', ST_Transform(ST_GeomFromText('POINT(43.980652 56.214880)', 4326), 3395), 30, '2017-05-17 11:03:19+03', 6, 9, '100500', 'unittest/8', 0.6, 0.9, 0, '2017-06-04 11:42:37+03', true, true, false, 0),
(3, '200', 'agents', ST_Transform(ST_GeomFromText('POINT(43.980559 56.214800)', 4326), 3395), 30, '2017-05-17 11:03:20+03', 6, 9, '100500', 'unittest/9', 0.5, 0.9, 0, '2017-06-04 11:42:37+03', true, true, false, 0),
(3, '300', 'agents', ST_Transform(ST_GeomFromText('POINT(43.980652 56.214880)', 4326), 3395), 30, '2017-05-17 11:03:19+03', 6, 9, '100500', 'unittest/10', 0.6, 0.9, 0, '2017-06-04 11:42:37+03', true, true, false, 90),
(3, '300', 'agents', ST_Transform(ST_GeomFromText('POINT(43.980559 56.214800)', 4326), 3395), 30, '2017-05-17 11:03:20+03', 6, 9, '100500', 'unittest/11', 0.05, 0.9, 0, '2017-06-04 11:42:37+03', true, true, false, 90);


INSERT INTO signals.track_point (assignment_id, source_id, pos, date, speed, heading, accuracy)
VALUES
(1, '123', ST_Transform(ST_GeomFromText('POINT(43.981049 56.215127)', 4326), 3395), '2017-05-17 11:03:17+03', 30, 210, 20),
(1, '123', ST_Transform(ST_GeomFromText('POINT(43.980807 56.214992)', 4326), 3395), '2017-05-17 11:03:18+03', 30, 210, 20),
(1, '123', ST_Transform(ST_GeomFromText('POINT(43.980652 56.214880)', 4326), 3395), '2017-05-17 11:03:19+03', 30, 210, 20),
(1, '123', ST_Transform(ST_GeomFromText('POINT(43.980559 56.214800)', 4326), 3395), '2017-05-17 11:03:20+03', 30, 210, 20),
(1, '123', ST_Transform(ST_GeomFromText('POINT(43.980467 56.214719)', 4326), 3395), '2017-05-17 11:03:21+03', 30, 210, 20),
(1, '123', ST_Transform(ST_GeomFromText('POINT(43.980381 56.214626)', 4326), 3395), '2017-05-17 11:03:22+03', 30, 210, 20),
(1, '123', ST_Transform(ST_GeomFromText('POINT(43.980279 56.214542)', 4326), 3395), '2017-05-17 11:03:23+03', 30, 210, 20),
(1, '123', ST_Transform(ST_GeomFromText('POINT(34.609718 31.677528)', 4326), 3395), '2017-05-18 08:14:44+03', 6, 185, 20),
(1, '123', ST_Transform(ST_GeomFromText('POINT(34.609693 31.677454)', 4326), 3395), '2017-05-18 08:14:51+03', 4, 183, 22),
(3, '200', ST_Transform(ST_GeomFromText('POINT(43.980652 56.214880)', 4326), 3395), '2017-05-17 11:03:19+03', 30, 210, 20),
(3, '200', ST_Transform(ST_GeomFromText('POINT(43.980559 56.214800)', 4326), 3395), '2017-05-17 11:03:20+03', 30, 210, 20),
(3, '300', ST_Transform(ST_GeomFromText('POINT(43.980652 56.214880)', 4326), 3395), '2017-05-17 11:03:19+03', 30, 210, 20),
(3, '300', ST_Transform(ST_GeomFromText('POINT(43.980559 56.214800)', 4326), 3395), '2017-05-17 11:03:20+03', 30, 210, 20);


INSERT INTO service.aoi (geom, name)
VALUES
(ST_Transform(ST_GeomFromText('MULTIPOLYGON(((43.9805941 56.214804592,43.941756557 56.253266991,43.977558457 56.27524928,43.977737624 56.275231126,44.063668576 56.232743111,43.9805941 56.214804592)))', 4326), 3395), 'aoi');

INSERT INTO ugc.assignment_object (object_id, assignment_id, created_at, position, type, comment)
VALUES
(1, 1, '2017-05-17 11:03:18+03', ST_GeomFromText('POINT(1 2)', 4326), 'barrier', NULL),
(2, 1, '2017-05-17 11:03:19+03', ST_GeomFromText('POINT(3 4)', 4326), 'deadend', NULL),
(3, 1, '2017-05-17 11:03:20+03', ST_GeomFromText('POINT(5 6)', 4326), 'bad_conditions', NULL),
(4, 1, '2017-05-17 11:03:21+03', ST_GeomFromText('POINT(7 8)', 4326), 'no_entry', 'some comment');

INSERT INTO service.region_privacy_params (geo_id, show_photos)
VALUES
(225, true);
