#pragma once

#include <assignment_object_feedback_task.h>
#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ugc/ugc.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ugc/assignment_object.h>

#include <maps/libs/auth/include/tvm.h>
#include <maps/libs/http/include/http.h>
#include <yandex/maps/pgpool3utils/pg_advisory_mutex.h>

#include <chrono>
#include <memory>

namespace maps {
namespace mrc {
namespace social {

class AnotherProcessIsRunning: public Exception {
    using Exception::Exception;
};

class AssignmentObjectFeedbackTasksEmitter {
public:
    AssignmentObjectFeedbackTasksEmitter(
        const maps::mrc::common::Config& cfg);

    db::TIds loadUnpostedAssignmentObjectIds();

    db::ugc::AssignmentObjects
    loadPublishableAssignmentObjects(const db::TIds& objectIds);

    void postFeedbackTasks(const db::ugc::AssignmentObjects& objects);

    bool lockDBAccess();

    void initTvmClient();

private:
    db::AssignmentObjectFeedbackTask
    postOneFeedbackTask(const db::ugc::AssignmentObject& object);

    const http::URL socialUrl_;
    http::Client httpClient_{};
    wiki::common::PoolHolder poolHolder_;

    maps::pgp3utils::PgAdvisoryXactMutex dbAccessMutex_;
    std::unique_ptr<NTvmAuth::TTvmClient> tvmClient_;
};

} // namespace social
} // namespace mrc
} // namespace maps
