#include <maps/wikimap/mapspro/services/mrc/long_tasks/assignment_object_feedback_tasks_emitter/emitter/emitter.h>

#include <library/cpp/testing/common/env.h>
#include <library/cpp/testing/gtest/gtest.h>
#include <maps/libs/common/include/file_utils.h>
#include <yandex/maps/mrc/unittest/database_fixture.h>
#include <yandex/maps/mrc/unittest/local_server.h>
#include <yandex/maps/mrc/unittest/unittest_config.h>

namespace maps {
namespace mrc {
namespace social {
namespace testing {

namespace {
// clang-format off
const std::string SQL_DATA_PATH
    = "/maps/wikimap/mapspro/services/mrc/long_tasks/assignment_object_feedback_tasks_emitter/tests/data.sql";
// clang-format on

class TestFixture
    : public unittest::WithUnittestConfig<unittest::DatabaseFixture,
                                          unittest::SocialStubFixture> {
public:
    TestFixture()
    {
        auto txn = pool().masterWriteableTransaction();
        txn->exec(
            maps::common::readFileToString(ArcadiaSourceRoot() + SQL_DATA_PATH));
        txn->commit();
    }
};

} // namespace

    TEST(assignment_object_feedback_tasks_suite, post_new_feedback_tasks)
    {
        TestFixture fixture;
        AssignmentObjectFeedbackTasksEmitter emitter{fixture.config()};

        auto objectIds = emitter.loadUnpostedAssignmentObjectIds();
        EXPECT_EQ(objectIds.size(), 3u);
        auto objects = emitter.loadPublishableAssignmentObjects(objectIds);
        EXPECT_EQ(objects.size(), 2u);

        emitter.postFeedbackTasks(objects);

        objectIds = emitter.loadUnpostedAssignmentObjectIds();
        EXPECT_EQ(objectIds.size(), 1u);
        objects = emitter.loadPublishableAssignmentObjects(objectIds);
        EXPECT_TRUE(objects.empty());
    }

} // namespace testing
} // namespace social
} // namespace mrc
} // namespace maps
