#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/ugc_event_logger/include/logger.h>

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/pgpool/include/pgpool3.h>
#include <maps/libs/sql_chemistry/include/filter.h>

#include <string>

namespace maps::mrc::ride_correction {

static const std::string GRINDER_WORKER_TYPE = "mrc-async-ride-correction";

static const std::string USER_ID_FIELD = "user_id";
static const std::string USER_IP_FIELD = "ip";
static const std::string USER_PORT_FIELD = "port";
static const std::string SOURCE_ID_FIELD = "source_id";
static const std::string START_TIME_FIELD = "start_time";
static const std::string END_TIME_FIELD = "end_time";
static const std::string SHOW_AUTHORSHIP_FIELD = "show_authorship";
static const std::string CLIENT_RIDE_ID_FIELD = "client_ride_id";

void updateRides(pgpool3::Pool& pool,
                 const std::string& userId,
                 const std::string& sourceId,
                 const std::optional<std::string>& clientRideId,
                 chrono::TimePoint startTime,
                 chrono::TimePoint endTime,
                 std::optional<bool> showAuthorship,
                 const ugc_event_logger::UserInfo& userInfo,
                 ugc_event_logger::Logger& ugcLogger);

sql_chemistry::FiltersCollection makeFeatureFilter(
    const std::string& userId,
    const std::string& sourceId,
    const std::optional<std::string>& clientRideId,
    chrono::TimePoint startTime,
    chrono::TimePoint endTime);

}  // namespace maps::mrc::ride_correction
