#pragma once

#include <maps/libs/http/include/http.h>

#include <string>
#include <sstream>

namespace maps::mrc::takeout {

class BaseFormData {
public:
    virtual ~BaseFormData() {}

    friend std::ostream& operator<<(std::ostream&, const BaseFormData&);
private:
    virtual void encode(std::ostream&) const = 0;
};

class NameValueFormData : public BaseFormData {
public:
    NameValueFormData(std::string name, std::string value)
        : name_{std::move(name)}
        , value_{std::move(value)}
    {}

private:
    void encode(std::ostream& os) const override;

    std::string name_;
    std::string value_;
};

class JsonAttachmentFormData : public BaseFormData {
public:
    JsonAttachmentFormData(std::string filename, std::string attachment)
        : filename_{std::move(filename)}
        , attachment_{std::move(attachment)}
    {}

private:
    void encode(std::ostream& os) const override;

    std::string filename_;
    std::string attachment_;
};

// See https://tools.ietf.org/html/rfc2046
class MultipartBuilder {
public:
    MultipartBuilder();
    void add(const BaseFormData& formData);

    void fill(http::Request& request) const;

private:
    std::string multipartBoundary_;
    mutable std::ostringstream content_;
};

} // namespace maps::mrc::takeout
