#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/track_point.h>

#include <yandex/maps/wiki/common/default_config.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>

#include <maps/libs/http/include/http.h>

#include <library/cpp/tvmauth/client/facade.h>

#include <string>

namespace maps::mrc::takeout {

class TakeoutUploader {
public:
    TakeoutUploader(const common::Config& config,
                    const wiki::common::ExtendedXmlDoc& nmapsConfig);

    void handleTakeoutUpload(const std::string& uid,
                             const std::string& takeoutJobId);

private:
    void handleTakeoutUploadImpl(const std::string& uid,
                                 const std::string& takeoutJobId);

    void addTvmTicketIfNeeded(http::Request& request);

    using HttpRequestProvider = std::function<http::Request()>;
    void performHttpRequestWithRetry(HttpRequestProvider requestProvider);

    void uploadToTakeout(http::Client& httpClient,
                         const std::string& takeoutJobId,
                         const std::string& filename,
                         const std::string& json);

    void notifyUploadingDone(http::Client& httpClient,
                             const std::string& takeoutJobId,
                             const std::vector<std::string>& filenames);

    // @return uploaded filenames
    std::vector<std::string>
    uploadTracksJson(http::Client& httpClient,
                     const std::string& takeoutJobId,
                     const db::TrackPoints& trackPoints);

    // @return uploaded filenames
    std::vector<std::string> uploadImagesJson(http::Client& httpClient,
                                              const std::string& takeoutJobId,
                                              const db::Features& features);

    // @return uploaded filenames
    std::vector<std::string> uploadNmapsData(http::Client& httpClient,
                                             const std::string& uid,
                                             const std::string& takeoutJobId);

    common::TakeoutConfig takeoutConfig_;
    wiki::common::PoolHolder poolHolder_;
    wiki::common::PoolHolder nmapsLongReadPool_;
    wiki::common::PoolHolder nmapsSocialPool_;

    std::optional<NTvmAuth::TTvmClient> tvmClient_;
};

} // namespace maps::mrc::takeout
