#include "metadata.h"
#include "maps/libs/chrono/include/time_point.h"
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/metadata_gateway.h>

#include <string>

namespace maps::mrc::drive_activity_stat {

namespace {

const std::string METADATA_PREFIX = "drive_activity_stat.";
const std::string LAST_RUN_TIME = METADATA_PREFIX + "last_run_time";
const std::string LAST_FIRMWARE_UPDATER_PROCESSED_TABLE =
    METADATA_PREFIX + "last_processed_table";
const std::string LAST_CARSHARING_TELEMATICS_PROCESSED_TABLE =
    METADATA_PREFIX + "last_carsharing_telematics_processed_table";

} // namespace

Metadata loadMetadata(pqxx::transaction_base& txn)
{
    Metadata result;

    auto values = db::MetadataGateway(txn).load(
        db::table::Metadata::key.like(METADATA_PREFIX + "%"));

    for (const auto& value: values) {
        if (value.key() == LAST_RUN_TIME) {
            result.lastSuccessRunTime = chrono::parseSqlDateTime(value.value());
        } else if (value.key() == LAST_FIRMWARE_UPDATER_PROCESSED_TABLE) {
            result.lastFirmwareUpdaterProcessedTable = value.value();
        } else if (value.key() == LAST_CARSHARING_TELEMATICS_PROCESSED_TABLE) {
            result.lastCarsharingTelematicsProcessedTable = value.value();
        }
    }
    return result;
}

void saveMetadata(pqxx::transaction_base& txn, const Metadata& metadata)
{
    std::vector<db::Metadata> dbMetadata;
    if (metadata.lastFirmwareUpdaterProcessedTable.has_value()) {
        dbMetadata.emplace_back(
            LAST_FIRMWARE_UPDATER_PROCESSED_TABLE, metadata.lastFirmwareUpdaterProcessedTable.value());
    }
    if (metadata.lastSuccessRunTime.has_value()) {
        dbMetadata.emplace_back(
            LAST_RUN_TIME,
            chrono::formatSqlDateTime(metadata.lastSuccessRunTime.value()));
    }
    if (metadata.lastCarsharingTelematicsProcessedTable.has_value()) {
        dbMetadata.emplace_back(
            LAST_CARSHARING_TELEMATICS_PROCESSED_TABLE,
            metadata.lastCarsharingTelematicsProcessedTable.value());
    }
    db::MetadataGateway(txn).upsert(dbMetadata);
}

} // namespace maps::mrc::drive_activity_stat
