#pragma once

#include <maps/libs/chrono/include/time_point.h>

#include <optional>

#include <pqxx/transaction_base>

namespace maps::mrc::drive_activity_stat {

struct Metadata {
    std::optional<std::string> lastFirmwareUpdaterProcessedTable;
    std::optional<std::string> lastCarsharingTelematicsProcessedTable;
    std::optional<chrono::TimePoint> lastSuccessRunTime;
};

Metadata loadMetadata(pqxx::transaction_base& txn);
void saveMetadata(pqxx::transaction_base& txn, const Metadata& metadata);

} // namespace maps::mrc::drive_activity_stat
