#pragma once
#include "yt_tables_types.h"
#include <maps/wikimap/mapspro/services/mrc/libs/yt/include/common.h>

#include <mapreduce/yt/interface/client.h>

#include <optional>
#include <string>
#include <vector>

namespace maps::mrc::drive_activity_stat {

void sortTable(NYT::IClientBase& client,
    const std::string& tablePath,
    const std::vector<std::string>& columns);

std::vector<std::string> evalTablesToProcess(
    NYT::IClientBase& client,
    const std::string& ytDirPath,
    const std::optional<std::string>& lastProcessedTable);

/// Calculates devices activity based on firmware-updater service logs.
/// The function is idempotent i.e. it can be called multiple times
/// with the same arguments and will produce the same result.
/// @param tables -- collection of YT-tables [ServiceLogRecord] path to process.
/// Each table is expected contain parsed nginx logs for service
/// be sorted by (vhost, status, iso_eventtime)
/// @param outputTablePath -- YT-path to output table [DeviceDailyActivityRecord]
void calculateCameraActivity(
    NYT::IClientBase& client,
    const std::string& firmwareUpdaterHost,
    const std::string& ytDirPath,
    const std::vector<std::string>& tables,
    const std::string& outputTablePath,
    std::optional<yt::PoolType> poolType);

/// Writes activity data from @param inputTablePath [DeviceDailyActivityRecord]
/// to @param outputTablePath [DeviceDailyActivityRecord].
/// If record with the same key already exists
/// in output table then it will be overwritten.
void mergeCameraActivityTables(
    NYT::IClientBase& client,
    const std::string& inputTablePath,
    const std::string& outputTablePath,
    std::optional<yt::PoolType> poolType);

/// Loads from @param ytDevicesRegistryPath the correspodance
/// between cameras and carsharing telematics, then calculates
/// for each correspondant device its total time im movement
void calculateCarsharingTelematicsActivity(
    NYT::IClientBase& client,
    const std::vector<DevicesRegistryRecord>& devicesRegistry,
    const std::string& ytDirPath,
    const std::vector<std::string>& tables,
    const std::string& outputTablePath,
    std::optional<yt::PoolType> poolType);


void mergeCarsharingTelematicsActivityTables(
    NYT::IClientBase& client,
    const std::string& inputTablePath,
    const std::string& outputTablePath,
    std::optional<yt::PoolType> poolType);

} // namespace maps::mrc::drive_activity_stat
