#include "fixture.h"
#include <maps/wikimap/mapspro/services/mrc/long_tasks/drive_activity_stat/lib/metadata.h>

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/log8/include/log8.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>
#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

namespace maps::mrc::drive_activity_stat::tests {


Y_UNIT_TEST_SUITE_F(metadata_should, Fixture)
{

Y_UNIT_TEST(load_and_save)
{
    log8::setLevel(log8::Level::DEBUG);

    const std::string TABLE = "table";
    const chrono::TimePoint DATE =
        chrono::parseSqlDateTime("2015-06-16 16:57:27.797396+03");

    auto txn = pool().masterWriteableTransaction();
    Metadata metadata = loadMetadata(*txn);

    EXPECT_FALSE(metadata.lastFirmwareUpdaterProcessedTable.has_value());
    EXPECT_FALSE(metadata.lastSuccessRunTime.has_value());

    metadata.lastFirmwareUpdaterProcessedTable = TABLE;
    metadata.lastSuccessRunTime = DATE;

    saveMetadata(*txn, metadata);

    Metadata loadedMetadata = loadMetadata(*txn);

    EXPECT_EQ(metadata.lastFirmwareUpdaterProcessedTable,
        loadedMetadata.lastFirmwareUpdaterProcessedTable);

    EXPECT_EQ(metadata.lastSuccessRunTime,
        loadedMetadata.lastSuccessRunTime);
}

} // Y_UNIT_TEST_SUITE_F(metadata_should, Fixture)


} // maps::mrc::drive_activity_stat::tests
