#pragma once

#include "photo.h"

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/pgpool/include/pgpool3.h>

#include <pqxx/transaction_base>

#include <optional>

namespace maps::mrc::excess_features_eraser {

void updateLastRunTime(pgpool3::Pool&, chrono::TimePoint now);

std::optional<chrono::TimePoint> loadLastRunTime(pqxx::transaction_base&);

Photos loadPhotos(pgpool3::Pool&,
                  const db::TIds& featureIds,
                  StringSet&,
                  chrono::TimePoint now);

db::TIds loadFeatureIdsFromHypotheses(pgpool3::Pool&,
                                      const db::TIds& featureIds);

void unpublishFeatures(pgpool3::Pool&, const db::TIds& featureIds);

}  // namespace maps::mrc::excess_features_eraser
