#include "fb.h"
#include "utility.h"

#include <maps/libs/log8/include/log8.h>
#include <maps/wikimap/mapspro/services/mrc/long_tasks/export_gen/lib/graph.h>

namespace maps::mrc::excess_features_eraser {

Datasets::Datasets(const std::string& graphDir,
                   const std::string& photoToEdgeDir)
    : graph_(concat(graphDir, "/", export_gen::GRAPH_COVERAGE_FILE))
    , photoToEdge_(concat(photoToEdgeDir, "/", export_gen::PHOTO_TO_EDGE_FILE))
{
    INFO() << concat(".graph=",
                     graph_.mrcVersion(),
                     ", .photo_to_edge=",
                     photoToEdge_.mrcVersion());
    REQUIRE(graph_.mrcVersion() == photoToEdge_.mrcVersion(),
            "version conflict");
}

db::TIds Datasets::getAllFeatureIds() const
{
    auto result = db::TIds{};
    size_t count = photoToEdge_.photoToEdgePairNumber();
    result.reserve(count);
    for (size_t i = 0; i < count; ++i) {
        result.push_back(photoToEdge_.photoToEdgePair(i).featureId());
    }
    common::sortUnique(result);
    INFO() << concat("total features ", result.size());
    return result;
}

db::TIds Datasets::getCoverageFeatureIds() const
{
    auto result = db::TIds{};
    for (size_t i = 0, count = graph_.edgesNumber(); i < count; ++i) {
        const auto& edge = graph_.edge(i);
        for (const auto& coverage : edge.coverages) {
            for (const auto& sublines : coverage.coveredSubpolylines) {
                result.push_back(sublines.featureId());
            }
        }
    }
    common::sortUnique(result);
    INFO() << concat("coverage features ", result.size());
    return result;
}

PhotoToEdgeRefs Datasets::getPhotoToEdgeRefs() const
{
    auto result = PhotoToEdgeRefs{};
    size_t count = photoToEdge_.photoToEdgePairNumber();
    result.reserve(count);
    for (size_t i = 0; i < count; ++i) {
        result.push_back(std::cref(photoToEdge_.photoToEdgePair(i)));
    }
    INFO() << concat("photo_to_edge ", result.size());
    return result;
}

}  // namespace maps::mrc::excess_features_eraser
