#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/photo_to_edge_pairs_reader.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/read.h>

#include <functional>

namespace maps::mrc::excess_features_eraser {

using PhotoToEdgeRef = std::reference_wrapper<const fb::PhotoToEdgePair>;
using PhotoToEdgeRefs = std::vector<PhotoToEdgeRef>;

class Datasets {
    fb::GraphReader graph_;
    fb::PhotoToEdgePairsReader photoToEdge_;

public:
    Datasets(const std::string& graphDir, const std::string& photoToEdgeDir);
    db::TIds getAllFeatureIds() const;
    db::TIds getCoverageFeatureIds() const;
    PhotoToEdgeRefs getPhotoToEdgeRefs() const;
};

}  // namespace maps::mrc::excess_features_eraser
