#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/suncalc.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>

#include <functional>
#include <set>
#include <unordered_map>

namespace maps::mrc::excess_features_eraser {

enum class AgeCategory : int8_t {
    Age_0_7,
    Age_7_30,
    Age_30_90,
    Age_90_180,
    Age_180,
    Min = Age_0_7,
    Max = Age_180,
};

struct Photo {
    geolib3::Point2 geodeticPos;          ///< 16 bytes
    std::string_view sourceId;            ///< 16 bytes
    db::TId featureId;                    ///< 8 bytes
    chrono::TimePoint timestamp;          ///< 8 bytes
    float quality;                        ///< 4 bytes
    db::CameraDeviation cameraDeviation;  ///< 2 bytes
    AgeCategory ageCategory;              ///< 1 byte
    common::DayPart dayPart;              ///< 1 byte
    db::FeaturePrivacy privacy;           ///< 1 byte
    bool useful;                          ///< 1 byte
};

using Photos = std::vector<Photo>;
using PhotoRef = std::reference_wrapper<Photo>;
using PhotoById = std::unordered_map<db::TId, PhotoRef>;
using StringSet = std::set<std::string>;

Photo toPhoto(const db::Feature&, StringSet&, chrono::TimePoint now);
void propagateUsefulOnRide(Photos&);
void setMedianQualityPerRide(Photos&);
db::TIds getUselessFeatureIds(const Photos&);

}  // namespace maps::mrc::excess_features_eraser
