#include "coverage.h"
#include "db.h"
#include "fb.h"
#include "unpublish.h"
#include "utility.h"

#include <maps/libs/log8/include/log8.h>

namespace maps::mrc::excess_features_eraser {

void unpublishExcessFeaturesMatchedOnGraph(pgpool3::Pool& pool,
                                           const std::string& graphDir,
                                           const std::string& photoToEdgeDir,
                                           chrono::TimePoint now,
                                           bool dryRun)
{
    auto datasets = Datasets{graphDir, photoToEdgeDir};
    auto notForCoverFeatureIds = loadNotForCoverFeatureIds(pool, datasets, now);
    INFO() << concat("not for cover features ", notForCoverFeatureIds.size());
    auto toUnpublishFeatureIds = makeDifference(
        notForCoverFeatureIds,
        loadFeatureIdsFromHypotheses(pool, notForCoverFeatureIds));
    INFO() << concat("unpublishing features ", toUnpublishFeatureIds.size());
    if (!dryRun) {
        unpublishFeatures(pool, toUnpublishFeatureIds);
    }
}

}  // namespace maps::mrc::excess_features_eraser
