#include "ecstatic.h"

#include <maps/libs/log8/include/log8.h>
#include <maps/libs/process/include/process.h>

namespace maps::mrc::export_gen {

namespace {

constexpr int TIMEOUT_FOR_DATASET_ACTIVATION_SEC = 3600 * 12;

} //namespace

void publish(const common::EcstaticClient& ecstaticClient,
             const std::string& dataset,
             const std::string& version,
             const std::string& dir)
{
    INFO() << "Uploading dataset '" << dataset << "' with version " << version;
    common::DatasetVersion datasetVersion{dataset, version};
    ecstaticClient.upload(dir, datasetVersion);
    ecstaticClient.activate(datasetVersion, common::EcstaticBranch::Stable);
    INFO() << "Successfully uploaded dataset";
}

void waitForActivation(const common::EcstaticClient& ecstaticClient,
                       const std::string& dataset,
                       const std::string& version)
{
    INFO() << "Waiting for dataset activation";
    common::DatasetVersion datasetVersion{dataset, version};
    ecstaticClient.waitForActivation(
        datasetVersion,
        common::EcstaticBranch::Stable,
        std::chrono::seconds(TIMEOUT_FOR_DATASET_ACTIVATION_SEC));
    INFO() << "Successfully activated dataset";
}

} //namespace maps::mrc::export_gen
