#pragma once

#include "graph.h"
#include "loader.h"
#include "tools.h"

namespace maps::mrc::export_gen {

/// Generates features datasets `yandex-maps-mrc`, `yandex-maps-mrc-features-secret`
/// Loads all the features and walk_objects into memory then
/// writes all the secret features into `yandex-maps-mrc-features-secret`,
/// all other features go into `yandex-maps-mrc`
FeaturesSummary generateExport(const ILoader&,
                               const std::string& mrcDatasetDir,
                               const std::string& featuresSecretDatasetDir,
                               const std::string& version,
                               db::TId lastFeatureTxnId,
                               fb::TSchemaVersion = CURRENT_FEATURE_SCHEMA_VERSION);

// re-call for backward compatibility
inline FeaturesSummary generateExport(
    pgpool3::Pool& pool,
    const std::string& mrcDatasetDir,
    const std::string& featuresSecretDatasetDir,
    const std::string& version)
{
    return generateExport(DbLoader{pool},
                          mrcDatasetDir,
                          featuresSecretDatasetDir,
                          version,
                          getLastFeatureTxnId(pool));
}

/**
 * Generates datasets for graph coverage:
 * - yandex-maps-mrc-graph / -pro
 * - yandex-maps-mrc-pedestrian-graph / -pro
 * Uses previous result to speed up if possible.
 *
 * @param GraphDescriptor - graph options
 * @param Pool - to download trackpoints for matcher
 * @param Photos - pictures, covering the graph
 * @param destGraph[Pro], @param destPhotoToEdge[Pro] - path to result datasets
 * @param mrcVersion - attribute of result dataset
 * @param prevMrcVersion - required version of previous result
 */
void generateGraph(const GraphDescriptor&,
                   pgpool3::Pool&,
                   const Photos&,
                   const std::string& destGraph,
                   const std::string& destGraphPro,
                   const std::string& destPhotoToEdge,
                   const std::string& destPhotoToEdgePro,
                   const std::string& mrcVersion,
                   const std::string& prevMrcVersion);

void generateActivation(const std::string& destDir, const std::string& version);

}  // namespace maps::mrc::export_gen
