#pragma once

#include "tools.h"

#include <maps/libs/edge_persistent_index/include/persistent_index.h>
#include <maps/libs/road_graph/include/graph.h>
#include <maps/libs/succinct_rtree/include/rtree.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/photo_to_edge_pairs_reader.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/read.h>
#include <maps/wikimap/mapspro/services/mrc/libs/graph_matcher_adapter/include/compact_graph_matcher_adapter.h>

#include <functional>

namespace maps::mrc::export_gen {

constexpr auto COVERAGE_ANGLE_DIFF_THRESHOLD =
    geolib3::Radians(geolib3::PI / 4.);
constexpr auto COVERAGE_METERS_SNAP_THRESHOLD = 20.5;
constexpr auto COVERAGE_METERS_MAX_PATH = 20;
constexpr auto MIN_COVERAGE_METERS = 1.;
constexpr auto MAX_TIME_INTERVAL = std::chrono::seconds(30);

static const std::string EDGES_PERSISTENT_INDEX_FILE =
    "edges_persistent_index.fb";
static const std::string ROAD_GRAPH_FILE = "road_graph.fb";
static const std::string RTREE_FILE = "rtree.fb";
static const std::string GRAPH_COVERAGE_FILE = "graph_coverage.fb";
static const std::string PHOTO_TO_EDGE_FILE = "photo_to_edge.fb";

struct Context {
    adapters::CompactGraphMatcherAdapter matcher;
    road_graph::PersistentIndex persistentIndex; 
    db::GraphType graphType;
    std::optional<fb::GraphReader> prevGraph;
    std::optional<road_graph::PersistentIndex> prevPersistentIndex;
    std::optional<fb::PhotoToEdgePairsReader> prevPhotoToEdge;

    Context(const std::string& graphPath,
            db::GraphType,
            const std::string& prevMrcVersion = {},
            const std::string& prevGraphPath = {},
            const std::string& prevPhotoToEdgePath = {});
};

using TrackPointProvider =
    std::function<db::TrackPoints(std::string_view sourceId,
                                  chrono::TimePoint startTime,
                                  chrono::TimePoint endTime)>;

TrackPointProvider makeTrackPointProviderStub();

TrackPointProvider makeTrackPointProvider(pgpool3::Pool&);

struct GraphSummary {
    fb::TGraph graph;
    std::vector<fb::PhotoToEdgePair> photoToEdgePairs;
};

GraphSummary makeGraphSummary(const Context&,
                              const Photos&,
                              const TrackPointProvider&);

}  // namespace maps::mrc::export_gen
